% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitstream-core.R
\name{bs_is_aligned}
\alias{bs_is_aligned}
\title{Is the current bit connection aligned at the given number of bits for reading/writing?}
\usage{
bs_is_aligned(bs, nbits = 8)
}
\arguments{
\item{bs}{Bistream connection object created with \code{bs_open()}}

\item{nbits}{number of bits of alignment w.r.t start of bitstream. Default: 8}
}
\value{
logical. TRUE if stream location is currently aligned to the 
   specified number of bits, otherwise FALSE
}
\description{
Is the current bit connection aligned at the given number of bits for reading/writing?
}
\examples{
bs  <- bs_open(raw(), 'w')
bs_write_bit(bs, c(TRUE, FALSE, TRUE))
bs_is_aligned(bs, 8)
bs_align(bs, nbits = 8)
bs_is_aligned(bs, 8)
output <- bs_close(bs)
output
}
