% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhclu_clara.R
\name{nhclu_clara}
\alias{nhclu_clara}
\title{Non-hierarchical clustering: CLARA}
\usage{
nhclu_clara(
  dissimilarity,
  index = names(dissimilarity)[3],
  seed = NULL,
  n_clust = c(1, 2, 3),
  maxiter = 0,
  initializer = "LAB",
  fasttol = 1,
  numsamples = 5,
  sampling = 0.25,
  independent = FALSE,
  algorithm_in_output = TRUE
)
}
\arguments{
\item{dissimilarity}{The output object from \code{\link[=dissimilarity]{dissimilarity()}} or
\code{\link[=similarity_to_dissimilarity]{similarity_to_dissimilarity()}}, or a \code{dist} object. If a \code{data.frame} is
used, the first two columns should represent pairs of sites (or any pair of
nodes), and the subsequent column(s) should contain the dissimilarity
indices.}

\item{index}{The name or number of the dissimilarity column to use. By
default, the third column name of \code{dissimilarity} is used.}

\item{seed}{A value for the random number generator (set to \code{NULL} for random
initialization by default).}

\item{n_clust}{An \code{integer} vector or a single \code{integer} specifying the
desired number(s) of clusters.}

\item{maxiter}{An \code{integer} defining the maximum number of iterations.}

\item{initializer}{A \code{character} string, either \code{"BUILD"} (used in the
classic PAM algorithm) or \code{"LAB"} (Linear Approximate BUILD).}

\item{fasttol}{A positive \code{numeric} value defining the tolerance for fast
swapping behavior. Defaults to 1.}

\item{numsamples}{A positive \code{integer} specifying the number of samples to
draw.}

\item{sampling}{A positive \code{numeric} value defining the sampling rate.}

\item{independent}{A \code{boolean} indicating whether the previous
medoids are excluded in the next sample. Defaults to \code{FALSE}.}

\item{algorithm_in_output}{A \code{boolean} indicating whether the original output
of \link[fastkmedoids:fastclara]{fastclara} should be included in the output.
Defaults to \code{TRUE} (see Value).}
}
\value{
A \code{list} of class \code{bioregion.clusters} with five components:
\enumerate{
\item{\strong{name}: A \code{character} string containing the name of the algorithm.}
\item{\strong{args}: A \code{list} of input arguments as provided by the user.}
\item{\strong{inputs}: A \code{list} of characteristics of the clustering process.}
\item{\strong{algorithm}: A \code{list} of all objects associated with the
clustering procedure, such as original cluster objects (only if
\code{algorithm_in_output = TRUE}).}
\item{\strong{clusters}: A \code{data.frame} containing the clustering results.}}

If \code{algorithm_in_output = TRUE}, the \code{algorithm} slot includes the output of
\link[fastkmedoids:fastclara]{fastclara}.
}
\description{
This function performs non-hierarchical clustering based on
dissimilarity using partitioning around medoids, implemented via
the Clustering Large Applications (CLARA) algorithm.
}
\details{
Based on \href{https://cran.r-project.org/package=fastkmedoids}{fastkmedoids}
package (\link[fastkmedoids:fastclara]{fastclara}).
}
\examples{
comat <- matrix(sample(0:1000, size = 500, replace = TRUE, prob = 1/1:1001),
20, 25)
rownames(comat) <- paste0("Site",1:20)
colnames(comat) <- paste0("Species",1:25)

dissim <- dissimilarity(comat, metric = "all")

#clust <- nhclu_clara(dissim, index = "Simpson", n_clust = 5)
   
}
\references{
Schubert E & Rousseeuw PJ (2019) Faster k-Medoids Clustering: Improving the
PAM, CLARA, and CLARANS Algorithms. \emph{Similarity Search and Applications}
11807, 171-187.
}
\seealso{
For more details illustrated with a practical example,
see the vignette:
\url{https://biorgeo.github.io/bioregion/articles/a4_2_non_hierarchical_clustering.html}.

Associated functions:
\link{nhclu_clarans} \link{nhclu_dbscan} \link{nhclu_kmeans} \link{nhclu_pam} \link{nhclu_affprop}
}
\author{
Pierre Denelle (\email{pierre.denelle@gmail.com}) \cr
Boris Leroy (\email{leroy.boris@gmail.com}) \cr
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
