% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCcoupled_class.R
\name{MCMCcoupled}
\alias{MCMCcoupled}
\alias{plot.MCMCcoupled}
\title{MCMCcoupled class}
\usage{
\method{plot}{MCMCcoupled}(
  x,
  y = NULL,
  ...,
  add_factor = NULL,
  alpha_conf = 0.5,
  fill_conf = "grey",
  linetype_conf = 2,
  linecol_conf = "grey45",
  linetype_pred = 1,
  alpha_pred = 0.5,
  fill_pred = "grey",
  linecol_pred = "grey45",
  line_col = "black",
  line_type = 1,
  line_size = 0.5,
  label_y = "logN",
  label_x = "time"
)
}
\arguments{
\item{x}{The object of class \code{MCMCcoupled} to plot.}

\item{y}{ignored}

\item{...}{ignored.}

\item{add_factor}{Includes the variation of one environmental factor in the plot.
It must be one of the column names in x$env_conditions.}

\item{alpha_conf}{transparency of the ribbon for the confidence interval. .5 by default.}

\item{fill_conf}{fill colour of the ribbon for the confidence interval. "grey" by default.}

\item{linetype_conf}{linetype for the line of the confidence interval. solid by default.}

\item{linecol_conf}{colour of the line for the confidence interval. "black" by default.}

\item{linetype_pred}{linetype for the line of the prediction interval. solid by default.}

\item{alpha_pred}{transparency of the ribbon for the prediction interval. .5 by default.}

\item{fill_pred}{fill colour of the ribbon for the prediction interval. "grey" by default.}

\item{linecol_pred}{colour of the line for the prediction interval. "grey45" by default.}

\item{line_col}{color of the line representing the median ("black" by default).}

\item{line_type}{type for the line representing the median (solid by default).}

\item{line_size}{size of the line representing the median. 1 by default.}

\item{label_y}{label of the  y axis. "logN" by default.}

\item{label_x}{label for the x-label ("time" by default).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The \code{MCMCcoupled} class contains the results of a growth prediction
consider parameter variability based on a model
fitted using \code{fit_coupled_growth()}

It is a subclass of list with items:
\itemize{
\item sample: Parameter sample used for the calculations.
\item simulations: Individual growth curves calculated based on the parameter
sample.
\item quantiles: Tibble with the limits of the credible intervals
(5\%, 10\%, 50\%, 90\% and 95\%) for each time point.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot(MCMCcoupled)}: plot of predicted growth (prediction band).

}}
