% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dorfman.Functions.R
\name{opt.pool.size}
\alias{opt.pool.size}
\title{Find the optimal pool size for Optimal Dorfman or
Thresholded Optimal Dorfman}
\usage{
opt.pool.size(p, max.p, se = 1, sp = 1)
}
\arguments{
\item{p}{a vector of each individual's probability of infection.}

\item{max.p}{the maximum allowable pool size.}

\item{se}{the sensitivity of the diagnostic test.}

\item{sp}{the specificity of the diagnostic test.}
}
\value{
The optimal common pool size for OD or TOD testing.
}
\description{
Find the optimal common pool size for Optimal Dorfman
(OD) or Thresholded Optimal Dorfman (TOD) testing.
}
\details{
This function finds the optimal common pool size for OD or
TOD testing. Using OD testing, all individuals are tested using an 
optimal common pool size. Using TOD testing, individuals are partitioned 
into low-risk and high-risk groups, and all low-risk individuals are 
tested using an optimal common pool size. See McMahan et al. (2012) for 
additional details on the implementation of OD or TOD testing.
}
\examples{
# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
set.seed(8135)
p.vec <- p.vec.func(p=0.02, alpha=1, grp.sz=10)
opt.pool.size(p=p.vec, max.p=3, se=0.95, sp=0.95)
}
\references{
\insertRef{McMahan2012a}{binGroup}
}
\seealso{
\url{http://chrisbilder.com/grouptesting/}

Other Informative Dorfman functions: 
\code{\link{accuracy.dorf}()},
\code{\link{characteristics.pool}()},
\code{\link{inf.dorf.measures}()},
\code{\link{opt.info.dorf}()},
\code{\link{pool.specific.dorf}()},
\code{\link{thresh.val.dorf}()}
}
\author{
This function was originally written by Christopher S. 
McMahan for McMahan et al. (2012). The function was obtained 
from \url{http://chrisbilder.com/grouptesting/}.
}
\concept{Informative Dorfman functions}
