% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_methods.R
\name{bigpca}
\alias{bigpca}
\title{BigPCA result objects}
\description{
Results returned by \code{\link[=pca_bigmatrix]{pca_bigmatrix()}}, \code{\link[=pca_stream_bigmatrix]{pca_stream_bigmatrix()}}, and
\code{\link[=pca_robust]{pca_robust()}} inherit from the \code{bigpca} class. The objects store the
component standard deviations, rotation/loadings, and optional scores while
recording which computational backend produced them. Standard S3 generics
such as \code{\link[=summary]{summary()}} and \code{\link[=plot]{plot()}} are implemented for convenience.

\code{bigpca} objects are lists produced by \code{\link[=pca_bigmatrix]{pca_bigmatrix()}},
\code{\link[=pca_stream_bigmatrix]{pca_stream_bigmatrix()}}, \code{\link[=pca_robust]{pca_robust()}}, and related helpers. They mirror
the structure of base R's \code{prcomp()} outputs while tracking additional
metadata for large-scale and streaming computations.

#' @seealso \code{\link[=pca_bigmatrix]{pca_bigmatrix()}}, \code{\link[=pca_stream_bigmatrix]{pca_stream_bigmatrix()}}, \code{\link[=pca_robust]{pca_robust()}},
\code{\link[=pca_plot_scree]{pca_plot_scree()}}, \code{\link[=pca_plot_scores]{pca_plot_scores()}}, \code{\link[=pca_plot_contributions]{pca_plot_contributions()}},
\code{\link[=pca_plot_correlation_circle]{pca_plot_correlation_circle()}}, and \code{\link[=pca_plot_biplot]{pca_plot_biplot()}}.
}
\section{Components}{

\describe{
\item{\code{sdev}}{Numeric vector of component standard deviations.}
\item{\code{rotation}}{Numeric matrix whose columns contain the variable
loadings (principal axes).}
\item{\code{center}, \code{scale}}{Optional numeric vectors describing the centring
and scaling applied to each variable when fitting the model.}
\item{\code{scores}}{Optional numeric matrix of principal component scores when
computed alongside the decomposition.}
\item{\code{column_sd}}{Numeric vector of marginal standard deviations for each
input variable.}
\item{\code{eigenvalues}}{Numeric vector of eigenvalues associated with the
retained components.}
\item{\code{explained_variance}, \code{cumulative_variance}}{Numeric vectors
summarising the fraction of variance explained by individual components
and the corresponding cumulative totals.}
\item{\code{covariance}}{Sample covariance matrix used to derive the
components.}
\item{\code{nobs}}{Number of observations used in the decomposition.}
}

The class also records the computation backend via
\code{attr(x, "backend")}, enabling downstream methods to adjust their
behaviour for streamed or robust results.
}

\seealso{
\code{\link[=pca_bigmatrix]{pca_bigmatrix()}}, \code{\link[=pca_stream_bigmatrix]{pca_stream_bigmatrix()}}, \code{\link[=summary.bigpca]{summary.bigpca()}},
\code{\link[=print.summary.bigpca]{print.summary.bigpca()}}, \code{\link[=plot.bigpca]{plot.bigpca()}}
}
\concept{bigpca}
