% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ic_acceptance_matrix.R
\name{plot_ic_acceptance_matrix}
\alias{plot_ic_acceptance_matrix}
\title{Plot IC Acceptance Matrix with Optional Rate-of-Improvement Overlay}
\usage{
plot_ic_acceptance_matrix(
  matrix_data,
  plot_title = "IC Acceptance Matrix Scatter Plot",
  plot_rate_of_improvement = TRUE,
  rate_limits = c(-400, 150),
  baseline_ic = NULL
)
}
\arguments{
\item{matrix_data}{A two-column \code{matrix} or \code{data.frame}. Column 1 must be
numeric IC scores in evaluation order; Column 2 must be a logical or numeric flag
(0/1) indicating whether the step was accepted.}

\item{plot_title}{\code{character(1)}. Title to draw above the plot.}

\item{plot_rate_of_improvement}{\code{logical(1)}. If \code{TRUE}, overlay the
first differences of the IC series on a secondary (right) y-axis along with a
horizontal reference line at zero.}

\item{rate_limits}{\code{numeric(2)}. Y-axis limits for the rate-of-improvement
overlay (i.e., \code{diff(IC)}), used only when \code{plot_rate_of_improvement = TRUE}.
Defaults to \code{c(-400, 150)}.}

\item{baseline_ic}{Optional \code{numeric(1)}. If provided, this value is used as the
baseline IC score (step 1) in place of \code{matrix_data[1, 1]} for plotting and for
computing \code{diff(IC)}. Default is \code{NULL} (use \code{matrix_data[1, 1]}).}
}
\value{
Invisibly returns \code{NULL}. Called for its plotting side effects.
}
\description{
Create a two-layer base R plot that visualizes information criterion (IC) scores
across a sequence of sub-model evaluations, highlighting which steps were
\emph{accepted} vs \emph{rejected}. Optionally, a secondary y-axis overlays the
\strong{rate of improvement} (first difference of IC scores) as a line with markers.
}
\details{
The function expects a two-column object where:
\itemize{
\item Column 1 contains the IC score at each step (numeric; lower is better).
\item Column 2 contains an indicator for acceptance (0 = rejected, 1 = accepted).
}
The first IC value is treated as the \emph{baseline} and is plotted as a larger
black point with a numeric label. If \code{baseline_ic} is supplied, it is used as
the baseline IC score (step 1) in place of \code{matrix_data[1, 1]} for both the
baseline annotation and the rate-of-improvement series (\code{diff(IC)}). This is
useful because \code{matrix_data} begins with the first evaluated shift model (rather
than the true no-shift baseline). To achieve this behavior, pass the true baseline via
\code{baseline_ic} to avoid labeling the first evaluated model as the baseline.

Accepted steps are drawn as blue filled points connected by a thin line; rejected
steps are drawn as small red crosses. When \code{plot_rate_of_improvement = TRUE},
the function overlays a secondary y-axis on the right that shows \code{diff(IC)} values
(the per-step change in IC; more negative implies improvement).

The function uses only base graphics. It sets plot margins and \code{mgp} via
\code{par()}, and (when overlaying) uses \code{par(new = TRUE)} to layer the IC plot over the
rate-of-improvement axes. Initial user par is reset on exit.

\strong{Axes and scaling.} Tick marks for the primary (IC) x/y axes are computed with
\code{pretty()} to give clean bounds. The secondary axis for the rate of improvement
uses \code{rate_limits} (default \code{c(-400, 150)}); adjust via the argument if your
expected \code{diff(IC)} range differs substantially.
}
\examples{
ic <- c(-1000, -1012, -1008, -1025, -1020, -1030)
accepted <- c(1, 0, 1, 0, 1)  # steps 2..6 relative to baseline
mat <- cbind(ic, c(1, accepted))  # mark baseline as accepted for plotting
plot_ic_acceptance_matrix(mat, plot_title = "IC Path")
# Avoid non-ASCII glyphs in titles on CRAN/CI:
plot_ic_acceptance_matrix(mat, plot_rate_of_improvement = TRUE)
# Override baseline IC:
plot_ic_acceptance_matrix(mat, baseline_ic = -995)

}
\seealso{
\code{\link[graphics]{par}}, \code{\link[graphics]{plot}}, \code{\link[graphics]{axis}},
\code{\link[graphics]{lines}}, \code{\link[graphics]{points}}, \code{\link[graphics]{legend}},
\code{\link[graphics]{mtext}}, \code{\link[graphics]{title}}
}
