% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa-generics-as_bids_tabular.R,
%   R/class032-bids_samples.R
\name{get_bids_samples}
\alias{get_bids_samples}
\alias{BIDSTabularSamples}
\title{'BIDS' samples table class}
\usage{
get_bids_samples(x, ...)

BIDSTabularSamples(content, meta = NULL)
}
\arguments{
\item{x}{R object such as file path, project instances, etc.}

\item{...}{passed to other methods or ignored}

\item{content, meta}{see \code{\link{BIDSTabular}}}
}
\value{
A \code{BIDSTabularSamples} instance inheriting
\code{\link{BIDSTabular}}.
}
\description{
A tabular containing a list of samples and their metadata.
The class is a child class of \code{\link{BIDSTabular}}, hence see
the methods there.
The original specification is at
\url{https://bids-specification.readthedocs.io/en/stable/modality-agnostic-files.html#samples-file}.
}
\examples{


# basic
tabular <- BIDSTabularSamples(
  data.frame(
    sample_id = "sample-001",
    participant_id = "sub-001",
    sample_type = "cell line"
  )
)
tabular


# convert existing tabular
tabular <- BIDSTabular(
  data.frame(
    sample_id = "sample-001",
    participant_id = "sub-001",
    sample_type = "cell line"
  )
)
tabular <- as_bids_tabular(tabular, cls = BIDSTabularSamples)


# save to tsv
tsv <- file.path(tempdir(), "samples.tsv")
paths <- save_bids_tabular(tabular, tsv)
print(paths)

# use base R to read
read.table(tsv, header = TRUE, na.strings = "n/a")

# get sidecar
cat(readLines(paths$sidecar_path), sep = "\n")

# clean up
unlink(tsv)
unlink(paths$sidecar_path)


}
\author{
Zhengjia Wang
}
