% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignEvolutionColors.R
\name{assignEvolutionColors}
\alias{assignEvolutionColors}
\title{Assign Colors to Thematic Evolution Nodes Based on Lineages}
\usage{
assignEvolutionColors(
  nexus,
  threshold = 0.5,
  palette = NULL,
  use_measure = "weighted"
)
}
\arguments{
\item{nexus}{A list object returned by \code{\link{thematicEvolution}} containing:
\itemize{
  \item \code{Nodes}: data frame with node information (name, group, id, sum, freq, etc.)
  \item \code{Edges}: data frame with edge information (from, to, weight measures)
  \item \code{TM}: list of thematic maps for each period
}}

\item{threshold}{Numeric. The minimum weight value for an edge to be considered a
"strong connection" (default: 0.5). Edges with weights >= threshold will propagate
the same color to connected nodes across periods.}

\item{palette}{Character vector. Optional custom color palette as hex codes. If NULL,
uses a default palette of 50+ distinct colors. Colors are assigned sequentially
without reuse.}

\item{use_measure}{Character. The measure to use for determining edge strength.
Can be one of:
\itemize{
  \item \code{"inclusion"}: uses the Inclusion measure (column 3 of Edges)
  \item \code{"stability"}: uses the Stability measure (column 5 of Edges)
  \item \code{"weighted"}: uses the weighted Inclusion measure (column 4 of Edges)
}
Default is "inclusion".}
}
\value{
Returns the modified \code{nexus} object with updated colors:
  \itemize{
    \item \code{Nodes$color}: updated with lineage-based colors
    \item \code{Edges$color}: edges connecting same-colored nodes receive the node color,
      others are grey
    \item \code{TM}: thematic maps updated with new cluster colors
  }
}
\description{
This function assigns colors to nodes in a thematic evolution analysis based on
their lineages across time periods. Nodes connected by strong edges (above a threshold)
receive the same color to visualize thematic continuity. Nodes with the same name
across periods that are not strongly connected to other nodes are also colored identically.
}
\details{
The function uses a multi-phase algorithm:
\enumerate{
  \item \strong{Phase 1}: Identifies lineages by following strong connections (weight >= threshold)
    from the first period forward. When a node has multiple strong connections, the
    strongest one determines the lineage.
  \item \strong{Phase 1.5}: Assigns the same lineage to nodes with identical names across
    periods if they are not already part of different strong connections.
  \item \strong{Phase 2}: Assigns unique colors from the palette to each identified lineage.
  \item \strong{Phase 3}: Assigns unique colors to isolated nodes (those without any lineage).
  \item \strong{Phase 4}: Colors edges based on their connected nodes - same color if both
    nodes share a color, grey otherwise.
  \item \strong{Final}: Updates thematic maps with the new color scheme.
}

Each lineage receives a unique color from the palette. No color is reused across
different lineages, ensuring clear visual distinction between independent thematic streams.
}
\examples{
\dontrun{
data(scientometrics, package = "bibliometrixData")
years <- c(2000, 2010)

nexus <- thematicEvolution(scientometrics, field = "ID",
                            years = years, n = 100, minFreq = 2)


# Use custom threshold and measure
nexus <- assignEvolutionColors(nexus, threshold = 0.6, use_measure = "weighted")

}

}
\seealso{
\code{\link{thematicEvolution}} to perform thematic evolution analysis.

\code{\link{plotThematicEvolution}} to visualize the colored evolution.
}
