% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bes_m_zhao.R
\name{bes_m_zhao}
\alias{bes_m_zhao}
\title{Zhao's entropy for landscape mosaics}
\usage{
bes_m_zhao(x, neighbourhood = 4)
}
\arguments{
\item{x}{SpatRaster, stars, RasterLayer, RasterStack, RasterBrick, matrix, or array containing one or more categorical rasters}

\item{neighbourhood}{The number of directions in which cell adjacencies are
considered as neighbours: 4 (rook's case), 8 (queen's case)}
}
\value{
A tibble
}
\description{
Calculates Zhao's entropy for landscape mosaics based on the Wasserstein metric (2019)
}
\examples{
library(terra)
library(bespatial)
mosaic = rast(system.file("raster/mosaic.tif", package = "bespatial"))
w_dists1 = bes_m_zhao(mosaic)
plot(mosaic, main = round(w_dists1$value, 2))
}
\references{
Zhao, Y., & Zhang, X. (2019). Calculating spatial configurational entropy of a landscape mosaic based on the Wasserstein metric. Landscape Ecology, 34(8), 1849-1858. https://doi.org/10.1007/s10980-019-00876-x
}
