% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_unsystematic}
\alias{check_unsystematic}
\title{Check for Unsystematic Data Violations}
\usage{
check_unsystematic(dat, ll = 1, c1 = 0.2, c2 = 0.1)
}
\arguments{
\item{dat}{A data frame containing the delay-discounting data. It must have at least two columns:
\itemize{
\item \code{id}: A unique identifier for the data set.
\item \code{y}: The indifference points to be analyzed.
}}

\item{ll}{A numeric value representing the larger later reward. Default is 1.}

\item{c1}{A numeric value for the threshold proportion for Criterion 1. Default is 0.2.}

\item{c2}{A numeric value for the threshold proportion for Criterion 2. Default is 0.1.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{id}: The unique identifier for the data set.
\item \code{c1_pass}: Logical value indicating whether Criterion 1 was passed.
\item \code{c2_pass}: Logical value indicating whether Criterion 2 was passed.
}
}
\description{
This function checks a dataset for violations of two criteria commonly used to identify unsystematic delay-discounting data:
\itemize{
\item Criterion 1: Any subsequent value of \code{y} exceeds the previous value by more than a specified proportion of the larger later reward (\code{ll}).
\item Criterion 2: The last value of \code{y} is not at least a specified proportion less than the first value of \code{y}.
}
}
\examples{
data <- tibble::tibble(
  id = c(rep("P1", 6)),
  x = c(1, 7, 30, 90, 180, 365), # delays
  y = c(0.9, 0.5, 0.3, 0.2, 0.1, 0.05) # indifference points
)
check_unsystematic(data, ll = 1, c1 = 0.2, c2 = 0.1)
}
