% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-middleware.R
\name{serveStaticFiles}
\alias{serveStaticFiles}
\title{File-serving middleware}
\usage{
serveStaticFiles(
  beakr = NULL,
  urlPath = NULL,
  rootPath = getwd(),
  rawTypesPattern = "image|json|octet|pdf|video",
  verbose = FALSE
)
}
\arguments{
\item{beakr}{\code{Beakr} instance or \code{NULL}.}

\item{urlPath}{String representing the URL directory underneath which static
file paths will appear.}

\item{rootPath}{String representing the absolute path used as the root
directory when searching for files on host machine. Defaults to the directory
in which the script is running.}

\item{rawTypesPattern}{String pattern identifying mime types to be returned
as raw bytes.}

\item{verbose}{Boolean to show a verbose static file information.}
}
\value{
A \code{Beakr} instance with added middleware.
}
\description{
Binds to GET requests that aren't handled by specified paths.
The result is to return files that are found on the host machine at the
requested path. Binary file types like \code{.png}, \code{.gif} or
\code{.pdf} are returned as raw bytes. All others are returned as characters.

Mime types are guessed using the \pkg{mime} package. The \code{rawTypesPattern}
parameter is used to match mime types that should be returned as raw bytes.
}
\details{
All files to be served in this manner must exist underneath the
host machine directory specified with \code{rootPath}. The directory
structure underneath \code{rootPath} will be mapped onto URLs underneath
\code{urlPath}. This helps when deploying web services at preordained URLs.

The example below presents files underneath host machine directory
\code{hostDir/} to be accessed at URLS under \code{test/}.
}
\note{
If you run the example in the console, be sure to
\code{stopServer(bekar)} when you are done.
}
\examples{
\donttest{
library(beakr)

# Create a .txt file in temp directory
hostDir <- tempdir()
file <- paste0(hostDir, "/my_file.txt")
cat("I am a text file.", file = file)

# Create an new beakr instance
beakr <- newBeakr()

# beakr pipeline
beakr \%>\%

  # Respond to GET requests at the "/hi" route
  httpGET(path = "/hi", function(req, res, err) {
    print("Hello, World!")
  }) \%>\%

  # Respond to GET requests at the "/bye" route
  httpGET(path = "/bye", function(req, res, err) {
    print("Farewell, my friends.")
  }) \%>\%

 # Host the directory of static files
 serveStaticFiles("/test", hostDir, verbose = TRUE) \%>\%

 # Start the server on port 25118
 listen(host = "127.0.0.1", port = 25118, daemon = TRUE)

# ------------------------------------------------------------
# POINT YOUR BROWSER AT:
# * http://127.0.0.1:25118/test/my_file.txt
#
# THEN, STOP THE SERVER WITH stopServer(beakr)
# ------------------------------------------------------------

# Stop the beakr instance server
stopServer(beakr)
}
}
