% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-middleware.R
\name{handleErrors}
\alias{handleErrors}
\title{Error-handling middleware}
\usage{
handleErrors(beakr = NULL, FUN = jsonError)
}
\arguments{
\item{beakr}{Beakr instance}

\item{FUN}{a function to handle the error response}
}
\value{
A \code{Beakr} instance with added middleware.
}
\description{
This default error handler should be added
at the end of the beakr pipeline, right before \code{listen()}. Errors
generated by any previous step will be returned within a JSON wrapper.
}
\note{
If you run the example in the console, be sure to
\code{stopServer(bekar)} when you are done.
}
\examples{
\donttest{
library(beakr)

# Create an new beakr instance
beakr <- newBeakr()

# beakr pipeline
beakr \%>\%

  # Respond to GET requests at the "/hi" route
  httpGET(path = "/hi", function(req, res, err) {
    print("Hello, World!")
  }) \%>\%

  # Respond to GET requests at the "/bye" route
  httpGET(path = "/bye", function(req, res, err) {
    print("Farewell, my friends.")
  }) \%>\%

  handleErrors() \%>\%

  # Start the server on port 25118
  listen(host = "127.0.0.1", port = 25118, daemon = TRUE)

# ------------------------------------------------------------
# POINT YOUR BROWSER AT:
# * http://127.0.0.1:25118/NOT_A_ROUTE
#
# THEN, STOP THE SERVER WITH stopServer(beakr)
# ------------------------------------------------------------

# Stop the beakr instance server
stopServer(beakr)
}
}
