% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Router.R
\docType{class}
\name{Router}
\alias{Router}
\title{Router Class}
\format{
An [`R6::R6Class`] generator for `Router` objects.
}
\description{
`Router` coordinates HTTP/WebSocket routing and middleware execution.
After instantiation, you can register middleware and event listeners; then
call `$invoke()` to run the request/response cycle.
}
\seealso{
[Response], [Request], [Error]
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{middleware}}{List of middleware entries.}

\item{\code{listeners}}{List of listeners (event handlers).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Router-addMiddleware}{\code{Router$addMiddleware()}}
\item \href{#method-Router-addListener}{\code{Router$addListener()}}
\item \href{#method-Router-processEvent}{\code{Router$processEvent()}}
\item \href{#method-Router-invoke}{\code{Router$invoke()}}
\item \href{#method-Router-clone}{\code{Router$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Router-addMiddleware"></a>}}
\if{latex}{\out{\hypertarget{method-Router-addMiddleware}{}}}
\subsection{Method \code{addMiddleware()}}{
Append middleware entry/entries to `middleware`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$addMiddleware(middleware)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{middleware}}{A middleware object/function or list of them.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Router-addListener"></a>}}
\if{latex}{\out{\hypertarget{method-Router-addListener}{}}}
\subsection{Method \code{addListener()}}{
Append a listener to `listeners`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$addListener(listener)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{listener}}{A listener object with fields like `event` and `FUN`.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Router-processEvent"></a>}}
\if{latex}{\out{\hypertarget{method-Router-processEvent}{}}}
\subsection{Method \code{processEvent()}}{
Dispatch an event to all matching listeners.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$processEvent(event, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{event}}{Event name (e.g., `"start"`, `"error"`, `"finish"`).}

\item{\code{...}}{Additional arguments forwarded to each listener `FUN`.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Router-invoke"></a>}}
\if{latex}{\out{\hypertarget{method-Router-invoke}{}}}
\subsection{Method \code{invoke()}}{
Run the routing/middleware pipeline and return a structured response.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$invoke(req, websocket_msg = NULL, websocket_binary = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{Raw request object or `Request` instance.}

\item{\code{websocket_msg}}{Optional WebSocket text message.}

\item{\code{websocket_binary}}{Optional WebSocket binary payload (raw).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Router-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Router-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
