% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{ggbnec_data}
\alias{ggbnec_data}
\title{Creates the data.frame for plotting with \code{\link{autoplot}}.}
\usage{
ggbnec_data(x, add_nec = TRUE, add_ecx = FALSE, xform = identity, ...)
}
\arguments{
\item{x}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}, as returned by function \code{\link{bnec}}.}

\item{add_nec}{Should NEC values be added to the plot? Defaults to TRUE.}

\item{add_ecx}{Should ECx values be added to the plot? Defaults to FALSE.}

\item{xform}{A function to apply to the returned estimated concentration
values.}

\item{...}{Additional arguments to be passed to \code{\link{ecx}}. By
default, function \code{\link{ecx}} returns EC10.}
}
\value{
A \code{\link[base]{data.frame}}.
}
\description{
Creates the data.frame for plotting with \code{\link{autoplot}}.
}
\examples{
\donttest{
library(bayesnec)
options(mc.cores = 2)
data(manec_example)

ggbnec_data(manec_example)
ggbnec_data(manec_example, add_ecx = TRUE, ecx_val = 50)
}

}
