% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{compare_models_loo}
\alias{compare_models_loo}
\title{Compare models using PSIS-LOO}
\usage{
compare_models_loo(results_new, results_base)
}
\arguments{
\item{results_new}{List. Results from new model.}

\item{results_base}{List. Results from base model.}
}
\value{
List with components:
  \describe{
    \item{loo_table}{Comparison table from loo::loo_compare}
    \item{deltaELPD}{Numeric difference in ELPD}
  }
}
\description{
Compares two fitted models using PSIS-LOO cross-validation.
}
\examples{
\donttest{
if (requireNamespace("loo", quietly = TRUE)) {
  # 1. Create mock 'loo' objects manually to avoid computation errors
  # Structure required by loo_compare: list with 'estimates' and class 'psis_loo'
  
  # Mock Model 1: ELPD = -100
  est1 <- matrix(c(-100, 5), nrow = 1, dimnames = list("elpd_loo", c("Estimate", "SE")))
  # Pointwise data (required for diff calculation). 10 observations.
  pw1 <- matrix(c(rep(-10, 10)), ncol = 1, dimnames = list(NULL, "elpd_loo"))
  
  loo_obj1 <- list(estimates = est1, pointwise = pw1)
  class(loo_obj1) <- c("psis_loo", "loo")
  
  # Mock Model 2: ELPD = -102 (worse)
  est2 <- matrix(c(-102, 5), nrow = 1, dimnames = list("elpd_loo", c("Estimate", "SE")))
  pw2 <- matrix(c(rep(-10.2, 10)), ncol = 1, dimnames = list(NULL, "elpd_loo"))
  
  loo_obj2 <- list(estimates = est2, pointwise = pw2)
  class(loo_obj2) <- c("psis_loo", "loo")
  
  # 2. Wrap in the structure expected by your package
  res_new <- list(diagnostics = list(loo = loo_obj1))
  res_base <- list(diagnostics = list(loo = loo_obj2))
  
  # 3. Compare (This will now run cleanly without warnings)
  cmp <- compare_models_loo(res_new, res_base)
  print(cmp)
}
}

}
