% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesLNP.R
\name{BayesLNP}
\alias{BayesLNP}
\title{Estimating the Student's t degrees of freedom (dof) with a Log-normal Prior over the dof}
\usage{
BayesLNP(y, ini.nu = 1, S = 1000, mu = 1, sigma.sq = 1)
}
\arguments{
\item{y}{an N-dimensional vector of continuous observations supported on the real-line}

\item{ini.nu}{the initial posterior sample value of the degrees of freedom (default is 1)}

\item{S}{the number of posterior samples (default is 1000)}

\item{mu}{mean of the Log-normal prior density (default is 1)}

\item{sigma.sq}{variance of the Log-normal prior density (default is 1)}
}
\value{
A vector of posterior sample estimates
\item{res}{an S-dimensional vector with the posterior samples}
}
\description{
\code{BayesLNP} samples from the posterior distribution of the degrees of freedom (dof) with Log-normal prior endowed upon the dof, using an Elliptical Slice Sampler (ESS).
}
\examples{

# data from Student's t-distribution with dof = 0.1
y = rt(n = 100, df = 0.1)

# running the Elliptical Slice Sampler (ESS) with default settings
nu = BayesLNP(y)
# reporting the posterior mean estimate of the dof
mean(nu)

# application to log-return (daily index values) of United States (S&P500)
data(index_return)
# log-returns of United States
index_return_US <- dplyr::filter(index_return, Country == "United States")
y = index_return_US$log_return_rate

# running the Elliptical Slice Sampler (ESS) with default settings
nu = BayesLNP(y)
# reporting the posterior mean estimate of the dof from the log-return data of US
mean(nu)

}
\references{
Lee, S. Y. (2022). "The Use of a Log-Normal Prior for the Student t-Distribution",
\emph{Axioms}, \doi{10.3390/axioms11090462}

Murray, I., Prescott Adams, R., MacKay, D. J. (2010). "Elliptical slice sampling",
\emph{Proceedings of the Thirteenth International Conference on Artificial Intelligence and Statistics}
}
