% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_elicitation_helper.R
\name{prior_elicitation_helper}
\alias{prior_elicitation_helper}
\alias{print.prior_elicitation}
\title{Prior Elicitation Helper}
\usage{
prior_elicitation_helper(
  expert_beliefs,
  parameter_type = "continuous",
  method = "quantile",
  data_sample = NULL,
  visualize = TRUE,
  ...
)

\method{print}{prior_elicitation}(x, ...)
}
\arguments{
\item{expert_beliefs}{List containing expert beliefs about parameters.
Elements: parameter_name, plausible_range, most_likely_value, confidence}

\item{parameter_type}{Character: "continuous", "discrete", or "proportion"}

\item{method}{Character: "quantile", "histogram", or "interactive"}

\item{data_sample}{Numeric vector of observed data (optional, for context)}

\item{visualize}{Logical. Show comparison plots (default: TRUE)}

\item{...}{Additional arguments}

\item{x}{Object of class \code{prior_elicitation} (for print method).}
}
\value{
Object of class \code{prior_elicitation} containing:
\itemize{
\item \code{recommended_prior} - Prior specification as prior() object
\item \code{parameter_summary} - Summary of expert inputs
\item \code{diagnostic_plots} - Visualizations of prior
\item \code{alternatives} - Alternative prior specifications
\item \code{sensitivity_note} - Guidance on sensitivity analysis
}
}
\description{
Interactive tool to translate expert knowledge into statistical priors.
Guides users through specification of prior distributions based on
domain expertise and data characteristics.
}
\details{
This function helps bridge the gap between domain expertise and
statistical prior specification. It uses several methods:
\enumerate{
\item Quantile method: Expert specifies percentiles
\item Histogram method: Expert draws rough distribution shape
\item Interactive: Step-by-step guided elicitation
}

The function then matches the inputs to standard distributions
(normal, t, gamma, beta, etc.) and suggests sensitivity analysis.
}
