% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{setup_cpplim}
\alias{setup_cpplim}
\title{Setup Limited Calibrated Power Prior Design Object}
\usage{
setup_cpplim(k, p0, shape1 = 1, shape2 = 1)
}
\arguments{
\item{k}{The number of baskets.}

\item{p0}{A common probability under the null hypothesis.}

\item{shape1}{First common shape parameter of the beta prior.}

\item{shape2}{Second common shape parameter of the beta prior.}
}
\value{
An S3 object of class \code{cpplim}
}
\description{
Setup Limited Calibrated Power Prior Design Object
}
\details{
The class \code{cpplim} implements a combined version of the adaptive power
prior (\code{app}) and the calibrated power prior (\code{cpp}), where the
parameter limiting the amount of information to be borrowed in the adaptive
power prior design is included in the calibrated power prior design.
}
\examples{
design_cpplim <- setup_cpplim(k = 3, p0 = 0.2)
}
\references{
Ollier, A., Morita, S., Ursino, M., & Zohar, S. (2020). An
adaptive power prior for sequential clinical trials - Application to bridging
studies. Statistical methods in medical research, 29(8), 2282–2294.

Baumann, L., Sauer, L. D., & Kieser, M. (2025). A Basket Trial
Design Based on Power Priors. Statistics in Biopharmaceutical Research,
17(3), 446–456. https://doi.org/10.1080/19466315.2024.2402275
}
