% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_evaluation.R
\name{get_evaluation.fujikawa}
\alias{get_evaluation.fujikawa}
\title{Evaluate a Basket Trial with Fujikawa's Design}
\usage{
\method{get_evaluation}{fujikawa}(
  design,
  n,
  r,
  lambda,
  level = 0.95,
  epsilon,
  tau,
  logbase = 2,
  ...
)
}
\arguments{
\item{design}{An object of class \code{fujikawa}.}

\item{n}{The sample sizes of the baskets. A vector must be used for varying sample sizes.}

\item{r}{Vector of responses.}

\item{lambda}{The posterior probability threshold.}

\item{level}{Level of the credibility intervals.}

\item{epsilon}{Tuning parameter that determines the amount of borrowing.
See \code{\link{setup_fujikawa}}).}

\item{tau}{Tuning parameter that determines how similar the baskets
have to be that information is shared. See \code{\link{setup_fujikawa}}).}

\item{logbase}{Tuning parameter. The base of the logarithm that is used to
calculate the Jensen-Shannon divergence.}

\item{...}{Further arguments.}
}
\value{
A list containing the point estimates of the basket-specific response rates and the
posterior probabilities that the estimated response rates are above a specified threshold p0.
}
\description{
Evaluate a Basket Trial with Fujikawa's Design
}
\examples{
design <- setup_fujikawa(k = 3, p0 = 0.2)

# Equal sample sizes
get_evaluation(design = design, n = 20, r = c(10, 15, 5),
  lambda = 0.95, epsilon = 2, tau = 0, iter = 100)

# Unequal sample sizes
get_evaluation(design = design, n = c(15, 20, 25),
   r = c(10, 15, 17), lambda = 0.95, epsilon = 2,
   tau = 0, iter = 100)
}
