% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_evaluation.R
\name{get_evaluation}
\alias{get_evaluation}
\title{Evaluate a Basket Trial}
\usage{
get_evaluation(design, ...)
}
\arguments{
\item{design}{An object created with one of the \code{setup} functions.}

\item{...}{Further arguments.}
}
\value{
A list containing the point estimates of the basket-specific response rates and,
for some methods, the posterior probabilities that the estimated response rates are above
a specified threshold p0.
}
\description{
Evaluate a Basket Trial
}
\examples{
# Example for a basket trial with Fujikawa's Design
design <- setup_fujikawa(k = 3, p0 = 0.2)

# Equal sample sizes
get_evaluation(design = design, n = 20, r = c(10, 15, 5),
  lambda = 0.95, epsilon = 2, tau = 0, iter = 100)

# Unequal sample sizes
get_evaluation(design = design, n = c(15, 20, 25),
   r = c(10, 15, 17), lambda = 0.95, epsilon = 2,
   tau = 0, iter = 100)

}
