% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting_triangle-methods.R
\name{as.matrix.reporting_triangle}
\alias{as.matrix.reporting_triangle}
\title{Convert reporting_triangle to plain matrix}
\usage{
\method{as.matrix}{reporting_triangle}(x, ...)
}
\arguments{
\item{x}{A \link{reporting_triangle} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A plain matrix without reporting_triangle class or attributes.
}
\description{
Returns a plain matrix representation of a reporting_triangle object,
removing the reporting_triangle class and custom attributes while
preserving row and column names.
}
\examples{
# Convert reporting_triangle to plain matrix
plain_mat <- as.matrix(example_downward_corr_rt)
class(plain_mat) # "matrix" "array"
}
\seealso{
Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.data.frame.reporting_triangle}()},
\code{\link{as_ChainLadder_triangle}()},
\code{\link{as_reporting_triangle}()},
\code{\link{as_reporting_triangle.data.frame}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{as_reporting_triangle.triangle}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_from_dates}()},
\code{\link{get_delays_unit}()},
\code{\link{get_max_delay}()},
\code{\link{get_mean_delay}()},
\code{\link{get_quantile_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_report_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{new_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_delay}()},
\code{\link{truncate_to_quantile}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
