% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_delay.R
\name{apply_delay}
\alias{apply_delay}
\title{Apply the delay to generate a point nowcast}
\usage{
apply_delay(reporting_triangle, delay_pmf, validate = TRUE)
}
\arguments{
\item{reporting_triangle}{Matrix of the reporting triangle to be
nowcasted, with rows representing the time points of reference and columns
representing the delays}

\item{delay_pmf}{Vector of delays assumed to be indexed starting at the
first delay column in \code{reporting_triangle}.}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}
}
\value{
\code{point_nowcast_matrix} Matrix of the same number of rows and columns
as the \code{rep_mat_to_nowcast} but with the missing values filled in as point
estimates
}
\description{
Generate a point estimate of a completed reporting square (or rectangle)
from a reporting triangle that we want to complete with a nowcast and a
delay PMF. Each element is computed by taking the product of the expected
number of total cases assigned to a reference time $t$ and the proportion
of those cases reported on delay $d$. The formula to obtain the expected
number of total cases as a function of the reporting delay and previous
observations was derived elsewhere.
This code was adapted from code written (under an MIT license)
by the Karlsruhe Institute of Technology RESPINOW
German Hospitalization Nowcasting Hub.
Modified from: \url{https://github.com/KITmetricslab/RESPINOW-Hub/blob/7cce3ae2728116e8c8cc0e4ab29074462c24650e/code/baseline/functions.R#L55} #nolint
}
\examples{
# Example 1: Standard usage with example dataset
delay_pmf <- estimate_delay(example_reporting_triangle)
point_nowcast_matrix <- apply_delay(
  reporting_triangle = example_reporting_triangle,
  delay_pmf = delay_pmf
)
print(point_nowcast_matrix)

# Example 2: Using delay PMF with negative entries from downward corrections
delay_pmf_negative <- c(0.7, 0.4, -0.15, 0.05)
nowcast_with_corrections <- apply_delay(
  reporting_triangle = example_downward_corr_rt,
  delay_pmf = delay_pmf_negative
)
# The nowcast includes negative predictions at delay 2,
# correctly reflecting expected downward corrections
print(nowcast_with_corrections)
}
\concept{generate_point_nowcasts}
