% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model}
\alias{model}
\title{Get a phenology model}
\usage{
model(m, ...)
}
\arguments{
\item{m}{Name of the model or the return value of another \code{model()}-call.}

\item{...}{List of parameters to customize the model.}
}
\value{
A phenology model. Can be passed to \code{\link[=phenology]{phenology()}}.
}
\description{
Returns a (customized) phenology model.
}
\examples{
\donttest{
# customize the temperature beetles need to fly for PHENIPS-Clim
m <- model('phenips-clim', tfly = 16)

# calculate phenology
p <- phenology(m, barrks_data(), .quiet = TRUE)

# plot generations
gens <- get_generations_rst(p)
terra::plot(gens)
}
}
\seealso{
Look at the customization manuals, to find out which parameters
can be customized for a specific model: \code{\link{model.bso.customize}}, \code{\link{model.phenips.customize}}, \code{\link{model.rity.customize}}, \code{\link{model.chapy.customize}}, \code{\link{model.joensson.customize}}, \code{\link{model.lange.customize}}, \code{\link{model.phenips_clim.customize}}.
}
