% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2.ord_ellipse_group.R
\name{ord_ellipse_group}
\alias{ord_ellipse_group}
\title{Compute Ellipse Coordinates for a Single Group}
\usage{
ord_ellipse_group(
  scores,
  group_var,
  group_name,
  axis1,
  axis2,
  kind = "se",
  conf = 0.95,
  method = "classic"
)
}
\arguments{
\item{scores}{Data frame of ordination scores.}

\item{group_var}{Name of grouping column.}

\item{group_name}{Name of the group to calculate ellipse.}

\item{axis1}{Name of first axis column.}

\item{axis2}{Name of second axis column.}

\item{kind}{Type of ellipse: "se" or "sd".}

\item{conf}{Confidence level.}

\item{method}{Covariance method: "classic" or "robust".}
}
\value{
Data frame of ellipse coordinates with group label.

A data frame with ellipse coordinates and group label.
}
\description{
Calculates ellipse coordinates for one group in ordination scores with robust or classic covariance.
}
\details{
Compute ellipse coordinates for a specific group in ordination scores

Calculates ellipse coordinates for one group from ordination scores,
supporting classical or robust covariance estimation.
}
\examples{
library(vegan)
data(dune)
data(dune.env)
pca <- rda(dune, scale = TRUE)
scores <- as.data.frame(scores(pca, display = "sites"))
scores$Group <- dune.env$Management
ell <- ord_ellipse_group(scores, "Group", "BF", "PC1", "PC2", kind = "se", method = "classic")
plot(ell$PC1, ell$PC2, type = "l")

}
