% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_utils.R
\name{twopoint_stable_var_ratio}
\alias{twopoint_stable_var_ratio}
\title{Calculate allocation ratio for a two-point stable-variance bandit.}
\usage{
twopoint_stable_var_ratio(A, e, alpha)
}
\arguments{
\item{A}{Integer. Size of the experiment. Must be a positive integer.}

\item{e}{Numeric. Empirical mean. Must be a numeric value.}

\item{alpha}{Numeric. Discount parameter.}
}
\value{
Numeric vector. Allocation ratio lambda.
}
\description{
Calculates the allocation ratio for a two-point stable-variance bandit, given the empirical mean and the discount parameter alpha.
}
\examples{
# Calculate the allocation ratio for a two-point stable-variance bandit with e=0.1 and alpha=0.5
twopoint_stable_var_ratio(1000, 0.1, 0.5)

}
