% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib.R
\name{encode}
\alias{encode}
\alias{decode}
\alias{decode_as_string}
\title{Base32 Encode and Decode}
\usage{
encode(x, alphabet = "crockford", padded = TRUE)

decode(x, alphabet = "crockford", padded = TRUE)

decode_as_string(x, alphabet = "crockford", padded = TRUE)
}
\arguments{
\item{x}{for \code{encode()}, must be either a character or raw vector. For \code{decode()}, a character vector.}

\item{alphabet}{default `"crockford". The base32 encoding alphabet to use. Must be one of "crockford", "rfc4648", "rfc4648lower", "rfc4648hex", "rfc4648hexlower", or "z".}

\item{padded}{default TRUE. Appends \code{=} to ensure that the final encoded chunk is 8 blocks of characters.}
}
\value{
\code{decode()} returns a \code{blob} object. \code{encode()} returns a character vector. \code{decode_as_string()} returns a character vector.
}
\description{
Base32 Encode and Decode
}
\details{
\code{decode()} returns a \code{blob} object which is a list of raw vectors.
If an error is encountered in \code{decode()} the result will be an NA.
}
\examples{
encode("hello")
encode("hello", padded = FALSE)
encode("hello", alphabet = "rfc4648")

# Decode base32 string
decode("NBSWY3DPEBLW64TMMQ======")
decode_as_string("NBSWY3DPEBLW64TMMQ======")
decode("NBSWY3DPEBLW64TMMQ", padded = FALSE)

}
