% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/azure-storage-client.R
\name{azr_storage_client}
\alias{azr_storage_client}
\title{Create an Azure Storage Client}
\usage{
azr_storage_client(
  storageaccount,
  filesystem,
  chain = default_credential_chain(),
  tenant_id = default_azure_tenant_id(),
  ...
)
}
\arguments{
\item{storageaccount}{A character string specifying the Azure Storage account name.}

\item{filesystem}{A character string specifying the filesystem (container) name.}

\item{chain}{A \link{credential_chain} instance for authentication. Defaults to
\code{\link[=default_credential_chain]{default_credential_chain()}}.}

\item{tenant_id}{A character string specifying the Azure tenant ID. Defaults to
\code{\link[=default_azure_tenant_id]{default_azure_tenant_id()}}, which reads \code{AZURE_TENANT_ID} from the environment.}

\item{...}{Additional arguments passed to the \link{api_storage_client} constructor.}
}
\value{
An \link{api_storage_client} object.
}
\description{
A convenience wrapper around \link{api_storage_client} that creates a configured
client for Azure Data Lake Storage Gen2 (ADLS Gen2) REST API operations.
}
\examples{
\dontrun{
# Create a storage client with default credentials
storage <- azr_storage_client(
  storageaccount = "mystorageaccount",
  filesystem = "mycontainer"
)

# Create a storage client with a specific tenant
storage <- azr_storage_client(
  storageaccount = "mystorageaccount",
  filesystem = "mycontainer",
  tenant_id = "00000000-0000-0000-0000-000000000000"
)
}
}
