% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_client_vpn_endpoint}
\alias{ec2_create_client_vpn_endpoint}
\title{Create Client Vpn Endpoint}
\usage{
ec2_create_client_vpn_endpoint(
  ClientCidrBlock,
  ServerCertificateArn,
  Authentication,
  ConnectionLogOptions,
  DnsServers = NULL,
  TransportProtocol = NULL,
  VpnPort = NULL,
  Description = NULL,
  SplitTunnel = NULL,
  DryRun = NULL,
  ClientToken = NULL,
  TagSpecification = NULL,
  SecurityGroupId = NULL,
  VpcId = NULL,
  SelfServicePortal = NULL,
  ClientConnectOptions = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{ClientCidrBlock}{Character. The IPv4 address range, in CIDR notation, from which to assign client IP addresses.}

\item{ServerCertificateArn}{Character. The ARN of the server certificate.}

\item{Authentication}{List. Information about the authentication method to be used to authenticate clients.}

\item{ConnectionLogOptions}{Object.   Information about the client connection logging options.}

\item{DnsServers}{List. Information about the DNS servers to be used for DNS resolution.[optional]}

\item{TransportProtocol}{Character.   The transport protocol to be used by the VPN session.  Default value: \code{udp}  [optional]}

\item{VpnPort}{Integer.   The port number to assign to the Client VPN endpoint for TCP and UDP traffic.[optional]}

\item{Description}{Character. A brief description of the Client VPN endpoint.[optional]}

\item{SplitTunnel}{Logical.   Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{Character. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{TagSpecification}{List. The tags to apply to the Client VPN endpoint during creation.[optional]}

\item{SecurityGroupId}{List. The IDs of one or more security groups to apply to the target network.[optional]}

\item{VpcId}{Character. The ID of the VPC to associate with the Client VPN endpoint.[optional]}

\item{SelfServicePortal}{Character.   Specify whether to enable the self-service portal for the Client VPN endpoint.[optional]}

\item{ClientConnectOptions}{Object. The options for managing connection authorization for new client connections.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Creates a
Client VPN endpoint. A Client VPN endpoint is the resource you create
and configure to enable and manage client VPN sessions. It is the
destination endpoint at which all client VPN sessions are
terminated.
}
\section{ClientCidrBlock}{

The
IPv4 address range, in CIDR notation, from which to assign client IP
addresses. The address range cannot overlap with the local CIDR of the
VPC in which the associated subnet is located, or the routes that you
add manually. The address range cannot be changed after the Client VPN
endpoint has been created. The CIDR block should be /22 or
greater.
}

\section{ServerCertificateArn}{

The ARN of the server certificate. For more
information, see the \href{https://docs.aws.amazon.com/acm/latest/userguide/}{AWS Certificate Manager User Guide}.
}

\section{Authentication}{

Information
about the authentication method to be used to authenticate
clients.
}

\section{ConnectionLogOptions}{


Information about the client connection logging options.

If you enable client connection logging, data about client connections
is sent to a Cloudwatch Logs log stream. The following information is
logged:
\itemize{
\item Client connection requests
\item Client connection results (successful and unsuccessful)
\item Reasons for unsuccessful client connection requests
\item Client connection termination time
}
}

\section{DnsServers}{

Information about the DNS servers to be used for
DNS resolution. A Client VPN endpoint can have up to two DNS servers. If
no DNS server is specified, the DNS address configured on the device is
used for the DNS server.
}

\section{TransportProtocol}{


The transport protocol to be used by the VPN session.

Default value: \code{udp}
}

\section{VpnPort}{


The port number to assign to the Client VPN endpoint for TCP and UDP
traffic.

Valid Values: \code{443} \| \code{1194}

Default Value: \code{443}
}

\section{Description}{

A brief description of the Client VPN
endpoint.
}

\section{SplitTunnel}{


Indicates whether split-tunnel is enabled on the AWS Client VPN
endpoint.

By default, split-tunnel on a VPN endpoint is disabled.

For information about split-tunnel VPN endpoints, see \href{https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html}{Split-Tunnel AWS Client VPN Endpoint}
in the \emph{AWS Client VPN Administrator Guide}.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{

Unique, case-sensitive
identifier that you provide to ensure the idempotency of the request.
For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{How to Ensure Idempotency}.
}

\section{TagSpecification}{

The
tags to apply to the Client VPN endpoint during
creation.
}

\section{SecurityGroupId}{

The IDs of one or more security groups to
apply to the target network. You must also specify the ID of the VPC
that contains the security groups.
}

\section{VpcId}{

The ID of the VPC
to associate with the Client VPN endpoint. If no security group IDs are
specified in the request, the default security group for the VPC is
applied.
}

\section{SelfServicePortal}{


Specify whether to enable the self-service portal for the Client VPN
endpoint.

Default Value: \code{enabled}
}

\section{ClientConnectOptions}{

The options for managing connection authorization
for new client connections.
}

