% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_keras_wrapper.R
\name{KERAS_WRAPPER}
\alias{KERAS_WRAPPER}
\alias{keras_wrapper}
\title{KERAS_WRAPPER class environment}
\usage{
keras_wrapper(
  keras_model = NULL,
  node_index = 1L,
  env = new.env(parent = parent.frame()),
  init_call = sys.call()
)
}
\arguments{
\item{keras_model}{Keras model. A trained computer vision model.}

\item{node_index}{Integer. An index indicating which node of the output layer
contains the visual signal strength. This is particularly useful
when the keras model has more than one output nodes.}

\item{env}{Environment. The instance environment.}

\item{init_call}{Call. Contents of the \code{..init_call..}. It is recommended to leave it
as default.}
}
\value{
An instance environment.
}
\description{
This is the class of keras wrapper,
inherited from \link[bandicoot:BASE]{bandicoot::BASE}. It is an environment
with S3 class \code{bandicoot_oop}.
}
\section{Functions}{
\itemize{
\item \code{keras_wrapper()}: Class constructor, same as \code{KERAS_WRAPPER$instantiate()}.

}}
\section{Class information}{
\subsection{Parent classes}{
\itemize{
\item Direct:
\itemize{
\item \link[bandicoot:BASE]{bandicoot::BASE}
}
}
}

\subsection{New methods}{
\itemize{
\item G:
\itemize{
\item \code{\link[=KERAS_WRAPPER$get_input_height]{KERAS_WRAPPER$get_input_height()}}
\item \code{\link[=KERAS_WRAPPER$get_input_width]{KERAS_WRAPPER$get_input_width()}}
}
\item I:
\itemize{
\item \code{\link[=KERAS_WRAPPER$image_to_array]{KERAS_WRAPPER$image_to_array()}}
\item \code{\link[=KERAS_WRAPPER$..init..]{KERAS_WRAPPER$..init..()}}
}
\item L:
\itemize{
\item \code{\link[=KERAS_WRAPPER$list_layer_name]{KERAS_WRAPPER$list_layer_name()}}
}
\item P:
\itemize{
\item \code{\link[=KERAS_WRAPPER$predict]{KERAS_WRAPPER$predict()}}
}
\item S:
\itemize{
\item \code{\link[=KERAS_WRAPPER$..str..]{KERAS_WRAPPER$..str..()}}
}
}
}
}

