% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$summary_density_plot}
\alias{AUTO_VI$summary_density_plot}
\title{Draw a summary density plot for the result}
\arguments{
\item{vss}{Numeric. Observed visual signal strength.}

\item{null_dist}{Numeric. Null visual signal strength.}

\item{boot_dist}{Numeric. Bootstrapped visual signal strength.}

\item{p_value}{Numeric. P-value of the visual test. See also
\code{\link[=AUTO_VI$p_value]{AUTO_VI$p_value()}}.}

\item{likelihood_ratio}{Numeric. Likelihood ratio of the visual test. See
also \code{\link[=AUTO_VI$likelihood_ratio]{AUTO_VI$likelihood_ratio()}}.}

\item{density_alpha}{Numeric. Alpha value for the density.}
}
\value{
A \code{ggplot}.
}
\description{
This function draws a summary density plot for the result.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$summary_plot(
  vss = self$check_result$observed$vss,
  null_dist = self$check_result$null$vss,
  boot_dist = self$check_result$boot$vss,
  p_value = self$check_result$p_value,
  likelihood_ratio = self$check_result$likelihood_ratio,
  density_alpha = 0.6
)
}\if{html}{\out{</div>}}
}
}
\examples{
keras_model <- try(get_keras_model("vss_phn_32"))
if (!inherits(keras_model, "try-error")) {
  myvi <- auto_vi(lm(dist ~ speed, data = cars), keras_model)

  myvi$check()
  myvi$summary_density_plot()
}

}
