% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{teste.anova}
\alias{teste.anova}
\title{Teste de ANOVA com pos-teste de Tukey HSD}
\usage{
teste.anova(
  ...,
  titulo = "ANOVA/Tukey HSD",
  x = "Eixo x",
  y = "Eixo y",
  ajuda = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{...}{Dois ou mais vetores numericos representando os grupos a serem comparados.}

\item{titulo}{Titulo do grafico (padrao: "ANOVA/Tukey HSD").}

\item{x}{Rotulo do eixo x (padrao: "Eixo x").}

\item{y}{Rotulo do eixo y (padrao: "Eixo y").}

\item{ajuda}{Se TRUE, exibe a ajuda desta funcao.}

\item{verbose}{Se TRUE, imprime mensagens detalhadas (default = TRUE)}
}
\value{
Objeto \code{aov} da analise de variancia.
}
\description{
Realiza analise de variancia (ANOVA) para comparar medias entre dois ou mais grupos,
seguida de teste post-hoc de Tukey HSD para identificar pares significativamente diferentes.
Exibe um grafico com boxplots e letras indicando significancia entre grupos.
}
\details{
A ANOVA verifica se ha diferenca significativa entre as medias de tres ou mais grupos.
Caso o resultado seja significativo, o teste post-hoc de Tukey HSD identifica quais pares de grupos diferem.
O grafico gerado apresenta boxplots para cada grupo com letras indicativas de diferencas estatisticas.
}
\examples{
g1 <- rnorm(10, 5)
g2 <- rnorm(10, 7)
g3 <- rnorm(10, 6)
teste.anova(g1, g2, g3)

}
