% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestharp.R
\name{rmd_to_forestharp}
\alias{rmd_to_forestharp}
\title{Convert to TreeHarp objects}
\usage{
rmd_to_forestharp(fname, verbose = FALSE)
}
\arguments{
\item{fname}{The filename that is to be read in.}

\item{verbose}{If TRUE, then messages will be printed to enable debugging.
dropped.}
}
\value{
There are three possible return outcomes: (1) NA, indicating that 
\code{\link[knitr]{purl}} was unable to extract the R expressions from the 
Rmd/qmd file. (2) A list with two components, named \code{forest} and
\code{line_nums}, each being NA. (3) A list with two components, named as in 
(2), containing the TreeHarp objects and a vector of line numbers.

If there are syntax errors in the file, the expressions may not be parsed
correctly. The \code{verbose} option will reflect this.
}
\description{
Reads in an Rmd file or an R script and converts it to a list of TreeHarp
objects.
}
\details{
If an Rmd or qmd file is supplied as input, it is first converted
to an R script before \code{\link[lintr]{get_source_expressions}} is used 
to try to parse the expressions. These expressions are then matched to the
original file to retrieve line numbers. Unlike previous versions of this 
function, line numbers will always be returned.

Expressions that could not be parsed will be returned as NA.

Line numbers are extracted using \code{\link[lintr]{get_source_expressions}} from
the lintr package.
}
\seealso{
\code{\link{fapply}}, \code{\link{extract_chunks}},
\code{\link{extract_chunks}}, \code{\link[lintr]{get_source_expressions}}
}
