% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_checks.R
\name{render_prechecks}
\alias{render_prechecks}
\title{Conducts checks before rendering file}
\usage{
render_prechecks(fname, in_place = TRUE, new_name, verbose = FALSE)
}
\arguments{
\item{fname}{The name of the Rmd/qmd file to check.}

\item{in_place}{If TRUE, the original file will be overwritten in place.}

\item{new_name}{If in_place is FALSE, this should be the full path to the 
new file to be written (including directory location).}

\item{verbose}{If TRUE, debugging messages will be printed.}
}
\value{
Either TRUE or FALSE. If TRUE, all View() lines have been commented,
and there are no system calls. If FALSE, it means there are system calls (to 
be screened further).
}
\description{
This routine conducts two checks before rendering the file: presence of 
View function, and presence of system() calls. The former is a nuisance,
while the latter is possibly nefarious.
}
