% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extract_benchmark_metrics}
\alias{extract_benchmark_metrics}
\title{Extract Benchmark Metrics from Scored Data}
\usage{
extract_benchmark_metrics(scored_data)
}
\arguments{
\item{scored_data}{A data frame with anomaly scores, typically the output
of \code{score_anomaly()} with a \code{ground_truth_col} specified.}
}
\value{
A list containing benchmarking metrics, or NULL if no metrics
  are available.
}
\description{
Extracts benchmarking metrics from a data frame that was scored with
\code{score_anomaly()} using ground truth labels.
}
\examples{
\donttest{
data <- data.frame(
  patient_id = 1:50,
  age = rnorm(50, 50, 15),
  is_error = sample(c(0, 1), 50, replace = TRUE, prob = c(0.95, 0.05))
)
scored_data <- score_anomaly(data, ground_truth_col = "is_error")
metrics <- extract_benchmark_metrics(scored_data)
print(metrics$auc_roc)
}
}
