% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_names.R
\name{expand_names}
\alias{expand_names}
\title{Expand names from abbreviated forms or initials}
\usage{
expand_names(short, expanded)
}
\arguments{
\item{short}{A character vector of potentially abbreviated names}

\item{expanded}{A character vector of potentially expanded names}
}
\value{
A character vector with the same length as \code{short}
}
\description{
Expand names from abbreviated forms or initials
}
\details{
When you have a list \code{x}of abbreviated and non-abbreviated names and you want
to deduplicate them, this function can be used as \code{expand_names(x, x)}, which
will return the most expanded version available in \code{x} for each name
}
\examples{
expand_names(
  c("W A Mozart", "Wolfgang Mozart", "Wolfgang A Mozart"),
  "Wolfgang Amadeus Mozart"
)

# Real-case application example
# Deduplicate names in list, as described in "details"
epi_pkg_authors <- cran_epidemiology_packages |>
  subset(!is.na(`Authors@R`), `Authors@R`, drop = TRUE) |>
  parse_authors_r() |>
  # Drop email, role, ORCID and format as string rather than person object
  lapply(function(x) format(x, include = c("given", "family"))) |>
  unlist()

# With all duplicates
length(unique(epi_pkg_authors))

# Deduplicate
epi_pkg_authors_normalized <- expand_names(epi_pkg_authors, epi_pkg_authors)

length(unique(epi_pkg_authors_normalized))

}
