% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-date.R
\name{auk_date}
\alias{auk_date}
\title{Filter the eBird data by date}
\usage{
auk_date(x, date)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{date}{character or date; date range to filter by, provided either as a
character vector in the format \code{"2015-12-31"} or a vector of Date objects.
To filter on a range of dates, regardless of year, use \code{"*"} in place of
the year.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on a range of dates.
This function only defines the filter and, once all filters have been
defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and perform the
filtering.
}
\details{
To select observations from a range of dates, regardless of year,
the  wildcard \code{"*"} can be used in place of the year. For example, using
\code{date = c("*-05-01", "*-06-30")} will return observations from May and June
of \emph{any year}. When using wildcards, dates can wrap around the year end.

This function can also work with on an \code{auk_sampling} object if the user only
wishes to filter the sampling event data.
}
\examples{
system.file("extdata/ebd-sample.txt", package = "auk") |>
  auk_ebd() |>
  auk_date(date = c("2010-01-01", "2010-12-31"))
  
# alternatively, without pipes
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_date(ebd, date = c("2010-01-01", "2010-12-31"))

# the * wildcard can be used in place of year to select dates from all years
system.file("extdata/ebd-sample.txt", package = "auk") |>
  auk_ebd() |>
  # may-june records from all years
  auk_date(date = c("*-05-01", "*-06-30"))
  
# dates can also wrap around the end of the year
system.file("extdata/ebd-sample.txt", package = "auk") |>
  auk_ebd() |>
  # dec-jan records from all years
  auk_date(date = c("*-12-01", "*-01-31"))
}
\seealso{
Other filter: 
\code{\link{auk_bbox}()},
\code{\link{auk_bcr}()},
\code{\link{auk_breeding}()},
\code{\link{auk_complete}()},
\code{\link{auk_country}()},
\code{\link{auk_county}()},
\code{\link{auk_distance}()},
\code{\link{auk_duration}()},
\code{\link{auk_exotic}()},
\code{\link{auk_extent}()},
\code{\link{auk_filter}()},
\code{\link{auk_last_edited}()},
\code{\link{auk_observer}()},
\code{\link{auk_project}()},
\code{\link{auk_protocol}()},
\code{\link{auk_species}()},
\code{\link{auk_state}()},
\code{\link{auk_time}()},
\code{\link{auk_year}()}
}
\concept{filter}
