% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node_kind}
\alias{node_kind}
\title{Find the kind of a node}
\usage{
node_kind(x)
}
\arguments{
\item{x}{A node, either from \code{\link[=tree_root]{tree_root()}} or from another \verb{node_*()}
function.}
}
\value{
A list with as many elements as in the input. Each element is a
character value.
}
\description{
Find the kind of a node
}
\examples{
src <- "x <- rnorm(100, mean = 2)
    any(duplicated(y))
    x <- z + 1
    any(duplicated(x))"

root <- src |>
  tree_new() |>
  tree_root()

root |>
  node_find(ast_rule(pattern = "any(duplicated($VAR))")) |>
  node_kind()

root |>
  node_find(ast_rule(pattern = "$X + $VALUE")) |>
  node_kind()
}
