% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_scalar}
\alias{assert_scalar}
\title{Assert input is a scalar}
\usage{
assert_scalar(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if \code{x} is not a scalar}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is a scalar, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert that an object is a scalar, meaning it is a length 1 atomic vector (such as \code{numeric(1)}, \code{character(1)} or \code{logical(1)}).
Note lists, data.frames and matrices are never considered scalar objects, even if they have only one element.
}
\examples{

# Pass when value is scalar
assert_scalar(5) # Passes
assert_scalar("single string") # Passes
assert_scalar(TRUE) # Passes

# Fail when value is not
try({
assert_scalar(c(1, 2, 3)) # Throws default error
assert_scalar(matrix(1:4, 2, 2)) # Throws default error
})


}
\concept{assert_type}
