% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_finder.R
\name{find_function_calls_in_folder}
\alias{find_function_calls_in_folder}
\title{Find specific function calls in a folder}
\usage{
find_function_calls_in_folder(
  test_folder,
  foo_strings,
  filter_for_test_that = FALSE
)
}
\arguments{
\item{test_folder}{folder containing all tests}

\item{foo_strings}{string vector of function names to search for}

\item{filter_for_test_that}{whether to filter for only functions used after the call to test_that. Default FALSE.}
}
\value{
dataframe with two columns. 'foo' contains function names, test_location
contains the location of the tests for each function (file and line number).
}
\description{
Runs find_function_calls_in_file on all files in a folder, and combined results into a
single dataframe
}
\examples{
folder_path <- assertHE_example("example_project/tests/testthat")
find_function_calls_in_folder(
  foo_strings = c("calculate_costs", "calculate_QALYs",
    "create_Markov_trace", "FOO_WITH_NO_TESTS"),
  test_folder = folder_path
)

}
