# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' High Performance Variant of apply()
#'
#'  High performance variant of apply() for a fixed set of functions.
#'  Considerable speedup obtained by this implementation is a trade-off for universality, user defined
#'  functions cannot be used with arrApply. However, about 20 most currently employed
#'  functions are available for usage. They can be divided in three types: \itemize{
#'    \item reducing functions (like mean(), sum() etc., giving a scalar when applied to a vector);
#'    \item mapping function (like normalise(), cumsum() etc., giving a vector of the same length
#'        as the input vector)
#'    \item and finally, vector reducing function (like diff() which produces
#'        result vector of a length different from the length of input vector).
#'  }
#'  Optional or mandatory additional arguments required by some functions
#'  (e.g. norm type for norm() or normalise() functions) can be
#'  passed as named arguments in '...'.
#' 
#' The following functions can be used as argument 'fun' (brackets
#' [] indicate additional parameters that can be passed in '...'): \itemize{
#'     \item reducing functions: \itemize{
#'         \item sum()
#'         \item prod()
#'         \item all()
#'         \item any()
#'         \item min()
#'         \item max()
#'         \item mean()
#'         \item median()
#'         \item sd() [norm_type]
#'         \item var() [norm_type]
#'         \item norm() [p],
#'         \item trapz() [x] (trapezoidal integration with respect to spacing in x,
#'            if x is provided, otherwise unit spacing is used)
#'         \item range();
#'       }
#'     \item mapping functions:\itemize{
#'         \item normalise() [p]
#'         \item cumsum()
#'         \item cumprod()
#'         \item multv() [v]
#'            (multiply a given dimension by a vector v, term by term)
#'         \item divv() [v]
#'            (divide by a vector v)
#'         \item addv() [v] (add a vector v)
#'         \item subv() [v] (subtract
#'            a vector v);
#'         }
#'     \item vector reducing/augmenting function:\itemize{
#'         \item diff() [k]
#'         \item conv() [v, shape] (convolve with vector v; shape="full" is equivalent
#'            to R's \code{convolve(..., rev(v), type="open")}).
#'         \item quantile() [p] (calculate quantiles corresponding to probabilities p;
#'            equivalent to R's \code{quantile(..., probs=p, type=5)}).
#'        }
#'     }
#' 
#' RcppArmadillo is used to do the job in very fast way but it comes at price
#' of not allowing NA in the input numeric array.
#' Vectors are allowed at input. They are considered as arrays of dimension 1.
#' So in this case, \code{idim} can only be 1.
#' NB. Here, range() is different from R version of the homonym function.
#'      In Armadillo, when applied to a vector, it returns a scalar max-min,
#'      while in R, it return a 2-component vector (min, max).
#' 
#' 
#' @param arr numeric array of arbitrary dimension
#' @param idim integer, dimension number along which a function must be applied
#' @param fun character string, function name to be applied
#' @param ... additional named parameters. Optional parameters can be helpful for
#'    the following functions:\itemize{
#'       \item sd(), var() [norm_type: 0 normalisation using N-1 entries (default);
#'          1 normalisation using N entries];
#'       \item norm() [p: integer >= 1 (default=2) or one of "-inf", "inf", "fro".]
#'       \item normalise() [p: integer >= 1, default=2]
#'       \item diff() [k: integer >= 1 (default=1) number of recursive application of diff().
#'          The size of idim-th dimension will be reduced by k.]
#'       \item trapz() [x: numerical vector of the same length as idim-th size of arr]
#'    }
#'    Mandatory parameter:\itemize{
#'       \item multv(), divv(), addv(), subv() [v: numerical vector of the same
#'          length as idim-th size of arr]
#'       \item quantile() [p: vector of probabilities in interval [0; 1]]
#'    }
#'
#' @return output array of dimension cut by 1 (the idim-th dimension
#'    will disappear for reducing functions) or of the same dimension
#'    as the input arr for mapping and vector reducing
#'    functions. For vector reducing functions, the idim-th dimension
#'    will be different from idim-th dimension of arr.
#'    The type of result (numeric or logical) depends on the function applied,
#'    logical for all() and any(), numerical -- for all other functions.
#' 
#' @examples
#'  arr=matrix(1:12, 3, 4)
#'  v1=arrApply(arr, 2, "mean")
#'  v2=rowMeans(arr)
#'  stopifnot(all(v1==v2))
#'  
#'  arr=array(1:24, dim=2:4) # dim(arr)=c(2, 3, 4)
#'  mat=arrApply(arr, 2, "prod") # dim(mat)=c(2, 4), the second dimension is cut out
#'  stopifnot(all(mat==apply(arr, c(1, 3), prod)))
#' 
#' @author Serguei Sokol <sokol at insa-toulouse.fr>
#' 
#' @export
arrApply <- function(arr, idim = 1L, fun = "sum", ...) {
    dots=list(...)
    .Call('_arrApply_arrApply', PACKAGE = 'arrApply', arr, idim, fun, dots)
}

