% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extdata.R
\docType{data}
\encoding{UTF-8}
\name{SD5903586_001.nc}
\alias{SD5903586_001.nc}
\title{Sample Argo File (Delayed Synthetic Data)}
\description{
This is the NetCDF file for cycle 1 of Argo float 5903586, downloaded from
\code{ftp://usgodae.org/pub/outgoing/argo/dac/aoml/5903586/profiles/SD5903586_001.nc}
on 2020 June 24 (this URL appears to be unreliable).
As its filename indicates, it holds "synthetic" data
in "delayed" mode. The oxygen values are adjusted by 16\%, as
is shown here, and in the documentation for \code{\link[=useAdjusted]{useAdjusted()}}.
}
\examples{
library(argoFloats)
a <- readProfiles(system.file("extdata", "SD5903586_001.nc", package = "argoFloats"))
a1 <- a[[1]]
# Illustrate oxygen adjustment
p <- a1[["pressure"]]
O <- a1[["oxygen"]]
Oa <- a1[["oxygenAdjusted"]]
Percent <- 100 * (Oa - O) / O
hist(Percent, main = "Oxygen adjustment")

}
\seealso{
Other raw datasets: 
\code{\link{D4900785_048.nc}},
\code{\link{R3901602_163.nc}},
\code{\link{SR2902204_131.nc}}
}
\concept{raw datasets}
