% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_process_document.R
\name{process_document}
\alias{process_document}
\title{Extract and process text from a document}
\usage{
process_document(path, extra_measures = NULL)
}
\arguments{
\item{path}{character. Path leading to the desired PDF file.}

\item{extra_measures}{character. To be implemented. Some documents are 
especially difficult for LLM to process due to a variety of 
issues such as size and formatting. \code{extra_measures} tries to improve 
future performance by cropping the document given to only the central passage
mentioning a specific species. \code{"header"} and, by extension, \code{"both"} require an mmd file
that is the output of nougatOCR.}
}
\value{
character. Fully processed text.
}
\description{
This function extracts text embedded in a \code{.pdf} or \code{.txt} file
and processes it so it can be safely used by LLM API's.
}
\examples{
path = arete_data("holzapfelae")
process_document(path)

extra_measures = list("mention", "Tricholathys spiralis")
}
