% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arakno.R
\name{distribution}
\alias{distribution}
\title{Get species distributions from WSC.}
\usage{
distribution(tax, order = FALSE)
}
\arguments{
\item{tax}{A taxon name or vector with taxa names.}

\item{order}{Order taxa alphabetically or keep as in tax.}
}
\value{
A data.frame with species and distribution. Family and genera names will be converted to species.
}
\description{
Get species distribution from the World Spider Catalogue.
}
\details{
This function will get species distributions from the World Spider Catalogue (2025).
}
\examples{
\dontrun{
distribution("Nemesia")
distribution(tax = c("Iberesia machadoi", "Amphiledorus ungoliantae"), order = TRUE)
}
}
\references{
World Spider Catalog (2025). World Spider Catalog. Version 26. Natural History Museum Bern, online at http://wsc.nmbe.ch. doi: 10.24436/2.
}
