% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{simulate_bias_priors}
\alias{simulate_bias_priors}
\title{Simulate bias priors (xi)}
\usage{
simulate_bias_priors(bias_spec, n_draws = 5000)
}
\arguments{
\item{bias_spec}{Output from build_bias_specification()}

\item{n_draws}{Number of Monte Carlo draws}
}
\value{
A numeric matrix of dimension n_draws x NN
}
\description{
Generates Monte Carlo samples from the prior distributions
specified for each bias type.
}
\examples{
## Simulate prior draws for two biases

bias_spec <- build_bias_specification(
  num_biases = 2,
  b_types = "Confounding",
  e_types = "Measurement Errors",
  ab_params = list(
    Confounding = c(2, 5)
  ),
  ex_params = list(
    `Measurement Errors` = 1.2
  )
)

xi <- simulate_bias_priors(bias_spec, n_draws = 1000)

## Dimensions correspond to (draws × biases)
dim(xi)

## Inspect prior distribution for first bias
hist(xi[, 1], main = "Prior for Confounding Bias", xlab = "Bias magnitude")

}
\references{
Kabali C (2025). AppRaise: Software for quantifying evidence uncertainty
in systematic reviews using a posterior mixture model. \emph{Journal of
Evaluation in Clinical Practice}, 31, 1-12. https://doi.org/10.1111/jep.70272.
}
\seealso{
\itemize{
\item \code{\link{build_bias_specification}}
\item \code{\link{run_appraise_model}}
\item \code{vignette("appraise-introduction")}
}
}
