% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{posterior_summary}
\alias{posterior_summary}
\title{Posterior summary statistics}
\usage{
posterior_summary(theta_samples, probs = c(0.025, 0.975))
}
\arguments{
\item{theta_samples}{Numeric vector of posterior draws}

\item{probs}{Credible interval probabilities}
}
\value{
Named numeric vector
}
\description{
Computes posterior mean and credible interval
}
\examples{
# Simulated posterior draws for a treatment effect
set.seed(123)
theta_samples <- rnorm(2000, mean = -0.4, sd = 0.15)

# Posterior mean and 95\% credible interval
posterior_summary(theta_samples)

# Custom credible interval (e.g., 90\%)
posterior_summary(theta_samples, probs = c(0.05, 0.95))

}
\references{
Kabali C (2025). AppRaise: Software for quantifying evidence uncertainty
in systematic reviews using a posterior mixture model. \emph{Journal of
Evaluation in Clinical Practice}, 31, 1-12. https://doi.org/10.1111/jep.70272
}
\seealso{
\itemize{
\item \code{\link{posterior_mixture}}
\item \code{vignette("appraise-introduction")}
}
}
