% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_emdc2.R
\name{apollo_emdc2}
\alias{apollo_emdc2}
\title{Extended MDC}
\usage{
apollo_emdc2(emdc_settings, functionality = "estimate")
}
\arguments{
\item{emdc_settings}{List of settings for the model. It includes the following.
\itemize{
  \item \strong{\code{avail}}: Named list of numeric vectors. Availability of each product. Can also be called "A".
  \item \strong{\code{continuousChoice}}: Named list of numeric vectors. Amount consumed of each inside good. Outside good must not be included. Can also be called "X".
  \item \strong{\code{cost}}: Named list of numeric vectors. Price of each product.
  \item \strong{\code{delta}}: Lower triangular numeric matrix, or list of lists. Complementarity/substitution parameter.
  \item \strong{\code{gamma}}: Named list of numeric vectors. Satiation parameter of each product.
  \item \strong{\code{sigma}}: Numeric scalar. Scale parameter.
  \item \strong{\code{nIter}}: Vector of two positive integers. Number of maximum iterations used during prediction, for the upper and lower iterative levels.
  \item \strong{\code{nRep}}: Scalar positive integer. Number of repetitions used when predictiong
  \item \strong{\code{rawPrediction}}: Scalar logical. When functionality is equal to "prediction", it returns the full set of simulations. Defaults is FALSE.
  \item \strong{\code{tolerance}}: Positive scalar Tolerance of the prediction algorithm.
  \item \strong{\code{utilities}}: Named list of numeric vectors (or matrices or arrays). Base utility of each product. Can also be called "V".
  \item \strong{\code{utilityOutside}}: Numeric vector (or matrix or array). Shadow price of the budget. Must be normalised to 0 for at least one individual. Default is 0 for every observation. Can also be called "V0".
}}

\item{functionality}{Character. Either "validate", "zero_LL", "estimate", "conditionals", "raw", "output" or "prediction"}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item \strong{\code{"estimate"}}: vector/matrix/array. Returns the probabilities for the chosen alternative for each observation.
          \item \strong{\code{"prediction"}}: List of vectors/matrices/arrays. Returns a list with the probabilities for all alternatives, with an extra element for the probability of the chosen alternative.
          \item \strong{\code{"validate"}}: Same as \code{"estimate"}, but it also runs a set of tests to validate the function inputs.
          \item \strong{\code{"zero_LL"}}: vector/matrix/array. Returns the probability of the chosen alternative when all parameters are zero.
          \item \strong{\code{"conditionals"}}: Same as \code{"estimate"}
          \item \strong{\code{"output"}}: Same as \code{"estimate"} but also writes summary of input data to internal Apollo log.
          \item \strong{\code{"raw"}}: Same as \code{"prediction"}
        }
}
\description{
Calculates the likelihood function of the extended MDC model. Can also predict and validate inputs.
}
\details{
This model extends the traditional multiple discrete-continuous (MDC) framework by (i) dropping
the need to define a budget, (ii) making the marginal utility of the outside good deterministic, 
and (iii) including complementarity and substitution in the model formulation. See the following  paper for more details:

Palma, D. & Hess, S. (2022) Extending the Multiple Discrete Continuous (MDC) modelling 
framework to consider complementarity, substitution, and an unobserved budget. Transportation 
Reserarch 161B, 13 - 35. https://doi.org/10.1016/j.trb.2022.04.005
}
