% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.aplms.R
\name{AIC.aplms}
\alias{AIC.aplms}
\title{Akaike information criterion}
\usage{
\method{AIC}{aplms}(object, ...)
}
\arguments{
\item{object}{APLMS object.}

\item{...}{other arguments}
}
\value{
a numeric value of the corresponding AIC.
}
\description{
Print the AIC of the fitted APLMS model.
}
\examples{
data(temperature)
temperature.df = data.frame(temperature,time=1:length(temperature))
model<-aplms::aplms(temperature ~ 1,
                   npc=c("time"), basis=c("cr"),Knot=c(60),
                   data=temperature.df,family=Powerexp(k=0.3),p=1,
                   control = list(tol = 0.001,
                                  algorithm1 = c("P-GAM"),
                                  algorithm2 = c("BFGS"),
                                  Maxiter1 = 20,
                                  Maxiter2 = 25),
                   lam=c(10))
AIC(model)
}
