% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_enrichment.R
\name{plot_enrichment_dotplot}
\alias{plot_enrichment_dotplot}
\title{Plot GO Enrichment Results as a Dot Plot}
\usage{
plot_enrichment_dotplot(
  annotaR_object,
  n_terms = 20,
  title = "Top GO Enrichment Results"
)
}
\arguments{
\item{annotaR_object}{An object processed by \code{add_go_terms()}. Must contain
\code{term_name}, \code{p_value}, and \code{gene} columns.}

\item{n_terms}{The maximum number of top terms to display, ordered by p-value.
Defaults to 20.}

\item{title}{The title of the plot.}
}
\value{
A ggplot object.
}
\description{
Creates a publication-ready dot plot from the results of an
\code{add_go_terms()} call. The plot shows the top enriched terms, with dot
size representing the number of genes and color representing the p-value.
}
\examples{
# Create a dummy annotaR object with enrichment data
annotated_data <- tibble::tibble(
  gene = c("TP53", "TP53", "EGFR"),
  term_name = c("Cell cycle", "Apoptosis", "Cell cycle"),
  p_value = c(0.001, 0.005, 0.001),
  source = "GO:BP",
  intersection = "TP53,EGFR"
)

plot_enrichment_dotplot(annotated_data)
}
