% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/c14_combine.R
\docType{methods}
\name{c14_combine}
\alias{c14_combine}
\alias{c14_combine-method}
\alias{c14_combine,numeric,numeric-method}
\title{Combine 14C}
\usage{
c14_combine(values, errors, ...)

\S4method{c14_combine}{numeric,numeric}(values, errors, groups = NULL)
}
\arguments{
\item{values}{A \code{\link{numeric}} vector giving the BP ages to be calibrated.}

\item{errors}{A \code{\link{numeric}} vector giving the standard deviation of the ages
to be calibrated.}

\item{...}{Currently not used.}

\item{groups}{A \code{\link{factor}} in the sense that \code{as.factor(groups)} defines the
the groups to combine with. If \code{NULL} (the default), all dates are combined.
\code{NA}s will be treated as isolated dates.}
}
\value{
A \code{\link{data.frame}} with the following columns:
\tabular{ll}{
\code{groups} \tab Group names                      \cr
\code{ages}   \tab Combined 14C ages                \cr
\code{errors} \tab Combined 14C standard deviations \cr
\code{chi2}   \tab Chi-squared test statistic       \cr
\code{p}      \tab Chi-squared test p-value         \cr
}
}
\description{
Combines radiocarbon dates.
}
\examples{
## Replicate Ward and Wilson (1978), p. 28
polach1972 <- data.frame(
  samples = c("ANU-7", "ANU-7", "ANU-7", "W-1571", "ANU-5",
              "C-800", "L-698D", "FSU-3", "Tx-44"),
  ages = c(14550, 15000, 13700, 14650, 11700, 10860, 11840, 11245, 10700),
  errors = c(270, 600, 300, 500, 260, 410, 100, 450, 210)
)

c14_combine(
  values = polach1972$ages,
  errors = polach1972$errors,
  groups = polach1972$samples
)
}
\references{
Ward, G. K. and Wilson, S. R. (1978). Procedures for Comparing and Combining
Radiocarbon Age Determinations: A Critique. \emph{Archaeometry} 20(1): 19‑31.
\doi{10.1111/j.1475-4754.1978.tb00208.x}.
}
\seealso{
Other radiocarbon tools: 
\code{\link{F14C}},
\code{\link{c14_calibrate}()},
\code{\link{c14_curve}()},
\code{\link{c14_ensemble}()},
\code{\link{c14_plot}},
\code{\link{c14_sample}()},
\code{\link{c14_spd}()},
\code{\link{c14_uncalibrate}()},
\code{\link{rec_plot}}
}
\author{
N. Frerebeau
}
\concept{radiocarbon tools}
