# amUnique(matchThreshold=0.9) for dataset ggSample

    Code
      ggDataset <- allelematch::amDataset(ggSample, indexColumn = 1, missingCode = "-99")

---

    Code
      cat(cmdstr)
    Output
      obj <- amUnique(ggDataset, matchThreshold=0.9)

---

    Code
      summary.amUnique(obj, csv = tmp)

---

    Code
      format(read.csv(tmp))
    Output
          uniqueGroup        rowType   uniqueIndex    matchIndex nUniqueGroup alleleMismatch matchThreshold cutHeight         Psib score Sex1 Sex2 X16S1_Gg2911 X16S1_Gg2912 Gg_13051 Gg_13052 Gg_16001 Gg_16002 Gg_44931 Gg_44932 Gg_59491 Gg_59492 Gg_65491 Gg_65492 Gg_78801 Gg_78802 Gg_86461 Gg_86462 Gg_91921 Gg_91922 Gg_91981 Gg_91982 Gg_93461 Gg_93462 Gg_113491 Gg_113492 Gg_121931 Gg_121932 Gg_141031 Gg_141032 Gg_147531 Gg_147532 Gg_156331 Gg_156332 Gg_156551 Gg_156552 Gg_167811 Gg_167812 Gg_173971 Gg_173972 Gg_177401 Gg_177402 Gg_183661 Gg_183662 Gg_207081 Gg_207082 Gg_207331 Gg_207332 Gg_208231 Gg_208232 Gg_222851 Gg_222852 Gg_230271 Gg_230272 Gg_231711 Gg_231712 Gg_239791 Gg_239792 Gg_253371 Gg_253372 Gg_263351 Gg_263352 Gg_272071 Gg_272072 Gg_284191 Gg_284192 Gg_284621 Gg_284622 Gg_290721 Gg_290722 Gg_290961 Gg_290962 Gg_291921 Gg_291922 Gg_293591 Gg_293592 Gg_293831 Gg_293832 Gg_305931 Gg_305932 Gg_307001 Gg_307002 Gg_323151 Gg_323152 Gg_327441 Gg_327442 Gg_329101 Gg_329102 Gg_331551 Gg_331552 Gg_333121 Gg_333122 Gg_338761 Gg_338762 Gg_339921 Gg_339922 Gg_342581 Gg_342582 Gg_346211 Gg_346212 Gg_353991 Gg_353992 Gg_357281 Gg_357282 Gg_364091 Gg_364092 Gg_369931 Gg_369932 Gg_376381 Gg_376382 Gg_379231 Gg_379232 Gg_390871 Gg_390872 Gg_404201 Gg_404202 Gg_404791 Gg_404792 Gg_405911 Gg_405912 Gg_409941 Gg_409942 Gg_416341 Gg_416342 Gg_423901 Gg_423902 Gg_425521 Gg_425522 Gg_427441 Gg_427442 Gg_430561 Gg_430562 Gg_431821 Gg_431822 Gg_449671 Gg_449672 Gg_451551 Gg_451552 Gg_462321 Gg_462322 Gg_475991 Gg_475992 Gg_479181 Gg_479182 Gg_486911 Gg_486912 Gg_489771 Gg_489772 Gg_491491 Gg_491492 Gg_494171 Gg_494172 Gg_496041 Gg_496042 Gg_504721 Gg_504722 Gg_507541 Gg_507542 Gg_548311 Gg_548312 Gg_556111 Gg_556112 Gg_570821 Gg_570822 Gg_573931 Gg_573932 Gg_602041 Gg_602042 Gg_623571 Gg_623572 Gg_652081 Gg_652082 Gg_671071 Gg_671072 Gg_676871 Gg_676872 Gg_687231 Gg_687232 Gg_726541 Gg_726542 Gg_733331 Gg_733332 Gg_743891 Gg_743892 Gg_775401 Gg_775402
      1             1         UNIQUE  Gg22_0478*40  Gg22_0478*40            1           18.6            0.9       0.1 4.539034e-20    NA    X    Y            X            X        X        X        X        Y      -99      -99        X        X        X        Y        X        X        X        Y        X        X        X        Y        X        Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X       -99       -99         X         X         Y         Y         X         X       -99       -99         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y       -99       -99         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y       -99       -99         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X
      2             2   CHECK_UNIQUE Gg22_0533*40b Gg22_0533*40b            2           18.6            0.9       0.1 5.908194e-20    NA    X    Y            X            X        X        Y        X        Y        X        X        X        X        Y        Y        Y        Y        X        X        X        Y        X        X        X        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X       -99       -99         X         Y         X         X         X         X       -99       -99         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y       -99       -99         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X       -99       -99         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y       -99       -99         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y       -99       -99         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y
      3             2 MULTIPLE_MATCH Gg22_0533*40b Gg22_0533*40c            2           18.6            0.9       0.1           NA  0.91    X    Y            X            X        X        Y        X        Y        X        X        X        X        Y        Y        Y        Y        X        X        X        Y        X        X        X        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y
      4             3         UNIQUE  Gg22_0558*40  Gg22_0558*40            1           18.6            0.9       0.1 8.236035e-21    NA    X    Y            X            X        X        X        X        X        X        Y        X        Y        X        Y        Y        Y        Y        Y        X        Y        X        X        X        Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y
      5             4         UNIQUE     Gg22_1495     Gg22_1495            1           18.6            0.9       0.1 2.046595e-17    NA  -99  -99            X            X        X        X        X        Y        Y        Y        X        X      -99      -99      -99      -99      -99      -99        X        X        X        X        Y        Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X       -99       -99       -99       -99         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y       -99       -99       -99       -99         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y       -99       -99         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         Y       -99       -99         X         X       -99       -99         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y       -99       -99         X         Y         X         Y         X         Y       -99       -99       -99       -99       -99       -99         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y       -99       -99         Y         Y         X         X         X         Y         X         X         Y         Y
      6             5         UNIQUE     Gg22_1506     Gg22_1506            1           18.6            0.9       0.1 2.385580e-20    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        X        X        Y        Y        Y        Y        X        X        X        Y        X        X        X        Y         X         X       -99       -99         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y       -99       -99         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X       -99       -99         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y
      7             6         UNIQUE    Gg22_1588c    Gg22_1588c            2           18.6            0.9       0.1 5.374975e-21    NA    X    X            X            X        X        X        X        X        Y        Y        X        Y        X        Y        X        Y        Y        Y        X        X        X        Y        Y        Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y
      8             6          MATCH    Gg22_1588c    Gg22_1588b            2           18.6            0.9       0.1           NA  0.95    X    X            X            X        X        X        X        X        Y        Y        X        Y        X        Y        X        Y        Y        Y        X        X        X        Y        Y        Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X       -99       -99         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y
      9             7         UNIQUE    Gg22_1592b    Gg22_1592b            1           18.6            0.9       0.1 3.397630e-21    NA    X    X            X            X        X        X        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y
      10            8         UNIQUE     Gg22_1595     Gg22_1595            2           18.6            0.9       0.1 1.091750e-20    NA    X    X            X            X        X        X        Y        Y        X        X        X        X      -99      -99        Y        Y        Y        Y        Y        Y        X        X        X        X       -99       -99         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y       -99       -99         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y       -99       -99         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X       -99       -99         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y
      11            8          MATCH     Gg22_1595    Gg22_1595c            2           18.6            0.9       0.1           NA  0.92    X    X            X            X        X        X        Y        Y        X        X        X        X        Y        Y        Y        Y        Y        Y        Y        Y        X        X        X        X       -99       -99         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y
      12            9         UNIQUE     Gg22_1596     Gg22_1596            1           18.6            0.9       0.1 6.271232e-20    NA    X    X            X            X        X        X        Y        Y        X        X        X        X        Y        Y        Y        Y        Y        Y        Y        Y        X        X        X        X       -99       -99         X         Y         X         Y         X         Y         X         X         X         Y       -99       -99       -99       -99         X         X         X         X       -99       -99         Y         Y         X         Y         X         X       -99       -99         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y       -99       -99         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y       -99       -99         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y       -99       -99         X         X         Y         Y       -99       -99         X         Y         Y         Y       -99       -99         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X
      13           10         UNIQUE    Gg22_1597T    Gg22_1597T            1           18.6            0.9       0.1 1.130522e-18    NA    X    X            X            X        X        X      -99      -99        X        X        X        X      -99      -99        Y        Y        Y        Y      -99      -99        X        X        X        X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y       -99       -99         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y       -99       -99         Y         Y         Y         Y         Y         Y       -99       -99         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y       -99       -99         Y         Y       -99       -99       -99       -99         X         Y         X         X         Y         Y       -99       -99         X         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y       -99       -99         X         X         X         X         Y         Y         X         Y         X         X       -99       -99       -99       -99         X         Y         X         X         X         X       -99       -99         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         X       -99       -99         X         X       -99       -99
      14           11         UNIQUE    Gg22_1597c    Gg22_1597c            3           18.6            0.9       0.1 3.754427e-21    NA    X    X            X            X        X        X        Y        Y        X        X        X        X        Y        Y        Y        Y        Y        Y        Y        Y        X        X        X        X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y       -99       -99         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y       -99       -99         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y
      15           11          MATCH    Gg22_1597c       Ind7379            3           18.6            0.9       0.1           NA  0.93    X    X            X            X        X        X        Y        Y        X        X        X        X        Y        Y        Y        Y        Y        Y        Y        Y        X        X        X        X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y
      16           11          MATCH    Gg22_1597c     Gg22_1597            3           18.6            0.9       0.1           NA  0.92    X    X            X            X        X        X        Y        Y        X        X        X        X        Y        Y        Y        Y        Y        Y        Y        Y        X        X        X        X         X         X         X         X         X         Y         X         Y       -99       -99         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y       -99       -99         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y       -99       -99         Y         Y         X         Y         X         X         Y         Y       -99       -99         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y       -99       -99       -99       -99         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X       -99       -99         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y       -99       -99         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y
      17           12         UNIQUE     Gg22_1612     Gg22_1612            2           18.6            0.9       0.1 8.626425e-22    NA    X    Y            X            X        X        X        X        Y        X        Y        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y
      18           12          MATCH     Gg22_1612    Gg22_1612b            2           18.6            0.9       0.1 8.626425e-22  1.00    X    Y            X            X        X        X        X        Y        X        Y        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y
      19           13         UNIQUE     Gg22_1615     Gg22_1615            3           18.6            0.9       0.1 1.102633e-20    NA    X    Y            X            X        X        Y        X        X        X        Y      -99      -99        Y        Y        X        Y        X        Y        X        X        Y        Y        X        Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y
      20           13          MATCH     Gg22_1615    Gg22_1615c            3           18.6            0.9       0.1           NA  0.99    X    Y            X            X        X        Y        X        X        X        Y        X        Y        Y        Y        X        Y        X        Y        X        X        Y        Y        X        Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y
      21           13          MATCH     Gg22_1615    Gg22_1615b            3           18.6            0.9       0.1           NA  0.97    X    Y            X            X        X        Y        X        X        X        Y        X        Y        Y        Y        X        Y        X        Y        X        X        Y        Y        X        Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y
      22           14         UNIQUE     Gg22_1617     Gg22_1617            1           18.6            0.9       0.1 3.004947e-20    NA    X    X            X            X        X        X        X        Y        X        X        X        Y        X        Y        Y        Y        Y        Y        X        Y      -99      -99        X        Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         Y
      23           15         UNIQUE     Gg22_1618     Gg22_1618            2           18.6            0.9       0.1 2.023006e-21    NA    X    Y            X            X        Y        Y        X        Y        X        Y        X        X        Y        Y        X        Y        X        X        X        Y        Y        Y        Y        Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X
      24           15          MATCH     Gg22_1618    Gg22_1618b            2           18.6            0.9       0.1 2.023006e-21  1.00    X    Y            X            X        Y        Y        X        Y        X        Y        X        X        Y        Y        X        Y        X        X        X        Y        Y        Y        Y        Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X
      25           16         UNIQUE     Gg22_1619     Gg22_1619            2           18.6            0.9       0.1 9.961477e-21    NA    X    X            X            X        X        Y        X        Y        X        X        X        X        X        Y        X        Y        X        Y        X        X        X        Y        X        Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X
      26           16          MATCH     Gg22_1619    Gg22_1619b            2           18.6            0.9       0.1           NA  0.99    X    X            X            X        X        Y        X        Y        X        X        X        X        X        Y        X        Y        X        Y        X        X        X        Y        X        Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X
      27           17         UNIQUE     Gg22_1624     Gg22_1624            2           18.6            0.9       0.1 1.056297e-20    NA    X    X            X            X        X        Y        X        X        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        X        X        Y        Y        Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y
      28           17          MATCH     Gg22_1624     Gg22_1623            2           18.6            0.9       0.1 1.723829e-20  0.99    X    X            X            X        X        Y        X        X        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        X      -99      -99        Y        Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y
      29           18         UNIQUE     Gg22_1625     Gg22_1625            1           18.6            0.9       0.1 3.180777e-19    NA    X    Y            X            X        Y        Y        Y        Y        Y        Y        X        X        Y        Y        X        X        X        X        X        X        X        X        X        Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X       -99       -99         X         X       -99       -99         Y         Y         Y         Y       -99       -99       -99       -99         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y       -99       -99       -99       -99         Y         Y         X         X         X         Y         X         Y         Y         Y       -99       -99         X         Y         X         X         Y         Y       -99       -99         X         X         Y         Y         X         X         X         X         Y         Y       -99       -99         X         X         X         X         Y         Y         X         Y         Y         Y       -99       -99         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y
      30           19         UNIQUE     Gg22_1626     Gg22_1626            1           18.6            0.9       0.1 9.542704e-21    NA    X    Y            X            X        Y        Y        Y        Y        X        Y        X        X        Y        Y        X        X        X        X        X        X        X        X        X        Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y
      31           20         UNIQUE     Gg22_1628     Gg22_1628            4           18.6            0.9       0.1 3.385648e-21    NA    X    X            X            X        X        X        Y        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        Y        X        Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y
      32           20          MATCH     Gg22_1628     Gg22_1629            4           18.6            0.9       0.1 3.385648e-21  1.00    X    X            X            X        X        X        Y        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        Y        X        Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y
      33           20          MATCH     Gg22_1628     Gg22_1630            4           18.6            0.9       0.1 3.385648e-21  1.00    X    X            X            X        X        X        Y        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        Y        X        Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y
      34           20          MATCH     Gg22_1628     Gg22_1631            4           18.6            0.9       0.1 3.385648e-21  1.00    X    X            X            X        X        X        Y        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        Y        X        Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y
      35           21         UNIQUE     Gg22_1632     Gg22_1632            3           18.6            0.9       0.1 1.163516e-20    NA    X    X            X            X        X        X        X        Y        Y        Y        X        X        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y
      36           21          MATCH     Gg22_1632     Gg22_1637            3           18.6            0.9       0.1 1.163516e-20  1.00    X    X            X            X        X        X        X        Y        Y        Y        X        X        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y
      37           21          MATCH     Gg22_1632     Gg22_1664            3           18.6            0.9       0.1           NA  0.91    X    X            X            X        X        X        X        Y        Y        Y        X        X        Y        Y        Y        Y        X        Y        X        Y      -99      -99        X        Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X       -99       -99         X         X         X         X         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y       -99       -99         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y       -99       -99         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         Y
      38           22         UNIQUE     Gg22_1634     Gg22_1634            2           18.6            0.9       0.1 5.491571e-21    NA    X    X            X            X        X        X        X        X        X        Y        X        X        Y        Y        Y        Y        X        Y        X        Y        X        Y        X        Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X
      39           22          MATCH     Gg22_1634     Gg22_1635            2           18.6            0.9       0.1 5.491571e-21  1.00    X    X            X            X        X        X        X        X        X        Y        X        X        Y        Y        Y        Y        X        Y        X        Y        X        Y        X        Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X
      40           23         UNIQUE     Gg22_1636     Gg22_1636            1           18.6            0.9       0.1 8.578374e-21    NA    X    X            X            X        X        Y        X        X        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y
      41           24         UNIQUE     Gg22_1639     Gg22_1639            1           18.6            0.9       0.1 2.781154e-20    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X        X        X        X        X        Y        Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         X         X         X
      42           25         UNIQUE     Gg22_1643     Gg22_1643            1           18.6            0.9       0.1 4.641853e-21    NA    X    X            X            X        Y        Y        X        Y        Y        Y        Y        Y        Y        Y        Y        Y        X        X        X        Y        X        X        Y        Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y
      43           26         UNIQUE     Gg22_1650     Gg22_1650            1           18.6            0.9       0.1 7.712983e-21    NA    X    X            X            X        Y        Y        X        X        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        X        X        Y        X        X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y
      44           27         UNIQUE     Gg22_1665     Gg22_1665            1           18.6            0.9       0.1 2.032317e-21    NA    X    Y            X            X        X        Y        X        X        X        Y        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        Y        Y        Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X
      45           28         UNIQUE     Gg22_1678     Gg22_1678            2           18.6            0.9       0.1 3.126329e-21    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        X        Y        Y        Y        X        Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y
      46           28          MATCH     Gg22_1678     Gg22_1679            2           18.6            0.9       0.1 3.126329e-21  1.00    X    Y            X            X        Y        Y        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        X        Y        Y        Y        X        Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y
      47           29         UNIQUE     Gg22_1680     Gg22_1680            1           18.6            0.9       0.1 1.021497e-22    NA    X    X            X            X        X        X        X        Y        X        Y        X        Y        X        X        X        X        X        Y        X        Y        X        X        X        X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y
      48           30         UNIQUE       Ind1701       Ind1701            1           18.6            0.9       0.1 1.957746e-20    NA    X    X            X            X        X        Y        X        Y        X        Y        Y        Y        X        Y        Y        Y        X        X        X        X        X        X        X        X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y
      49           31         UNIQUE       Ind1702       Ind1702            1           18.6            0.9       0.1 2.289573e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        Y        Y      -99      -99        Y        Y        X        X        X        X        X        X        X        Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y       -99       -99         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X
      50           32         UNIQUE       Ind1703       Ind1703            1           18.6            0.9       0.1 1.154182e-19    NA    X    Y            X            X        X        X        Y        Y      -99      -99        X        Y        X        Y      -99      -99        X        Y        X        Y        X        X        X        Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y       -99       -99         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X       -99       -99         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y       -99       -99         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X
      51           33         UNIQUE       Ind1706       Ind1706            1           18.6            0.9       0.1 4.176238e-20    NA    X    X            X            X        X        Y        Y        Y        Y        Y        X        Y        Y        Y        Y        Y        X        Y        X        X        X        Y        X        Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y
      52           34         UNIQUE       Ind1707       Ind1707            1           18.6            0.9       0.1 2.312476e-20    NA    X    Y            X            X        Y        Y        Y        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X
      53           35         UNIQUE       Ind1708       Ind1708            1           18.6            0.9       0.1 7.408373e-21    NA    X    X            X            X        X        X        X        Y        X        Y        X        Y        X        X        Y        Y        X        Y        X        Y        X        X        Y        Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y
      54           36         UNIQUE       Ind1711       Ind1711            1           18.6            0.9       0.1 2.546080e-20    NA    X    Y            X            X        Y        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        X        X        X        Y        X        Y        X        Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y
      55           37         UNIQUE       Ind1716       Ind1716            1           18.6            0.9       0.1 1.122440e-20    NA    X    Y            X            X        Y        Y        X        X        Y        Y        X        Y        X        Y        X        Y        X        X        Y        Y        X        Y        X        Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X
      56           38         UNIQUE       Ind1717       Ind1717            1           18.6            0.9       0.1 2.821046e-21    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        Y        Y        Y        Y        Y        Y        Y        X        Y        X        Y        X        Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y
      57           39         UNIQUE       Ind1718       Ind1718            1           18.6            0.9       0.1 3.195784e-21    NA    X    X            X            X        X        X        X        Y        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        Y        Y        X        X         X         X         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y
      58           40         UNIQUE       Ind1719       Ind1719            1           18.6            0.9       0.1 4.743227e-21    NA    X    X            X            X        X        X        X        Y        Y        Y        X        X        X        X        Y        Y        X        X        X        X        X        Y        X        Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      59           41         UNIQUE       Ind1721       Ind1721            1           18.6            0.9       0.1 6.361885e-21    NA    X    X            X            X        X        X        X        X        X        X        X        Y        X        Y        X        X        X        X        X        Y        X        X        X        X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y       -99       -99         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y
      60           42         UNIQUE       Ind1722       Ind1722            1           18.6            0.9       0.1 6.363809e-21    NA    X    Y            X            X        X        X        Y        Y        Y        Y        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        X        X        X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X       -99       -99         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         Y         Y
      61           43         UNIQUE       Ind1724       Ind1724            1           18.6            0.9       0.1 1.089890e-20    NA    X    X            X            X        X        Y        X        Y        X        X        X        X        X        Y        X        X        X        Y        X        Y        X        Y        Y        Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X
      62           44         UNIQUE       Ind1725       Ind1725            1           18.6            0.9       0.1 1.031061e-20    NA    X    X            X            X        X        X        X        Y        X        X        X        X        Y        Y        Y        Y        X        Y        X        Y        X        X      -99      -99         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y       -99       -99         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X
      63           45         UNIQUE       Ind1726       Ind1726            1           18.6            0.9       0.1 2.878835e-20    NA    X    X            X            X        X        X        X        Y        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        X        X        X        X        Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y
      64           46         UNIQUE       Ind1727       Ind1727            1           18.6            0.9       0.1 2.203880e-20    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y
      65           47         UNIQUE       Ind1732       Ind1732            1           18.6            0.9       0.1 5.044001e-21    NA    X    Y            X            X        X        X        Y        Y        X        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y
      66           48         UNIQUE       Ind1733       Ind1733            1           18.6            0.9       0.1 4.228572e-21    NA    X    X            X            X        X        Y        Y        Y        Y        Y        X        X        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y
      67           49         UNIQUE       Ind1734       Ind1734            1           18.6            0.9       0.1 1.521254e-20    NA    X    Y            X            X        Y        Y        X        X        X        Y        X        Y        Y        Y        X        X        X        X        Y        Y        X        X        X        Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y
      68           50         UNIQUE       Ind1735       Ind1735            1           18.6            0.9       0.1 2.639978e-20    NA    X    Y            X            X        Y        Y        X        X        X        X        X        Y        Y        Y        X        Y        X        X        Y        Y        X        Y        X        Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y       -99       -99         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X
      69           51         UNIQUE       Ind1737       Ind1737            1           18.6            0.9       0.1 2.609857e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        X        Y        Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y
      70           52         UNIQUE       Ind1738       Ind1738            1           18.6            0.9       0.1 3.241456e-20    NA    X    X            X            X        Y        Y        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        X        X        X        Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y
      71           53         UNIQUE       Ind1739       Ind1739            1           18.6            0.9       0.1 2.723218e-20    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        X        Y        Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y
      72           54         UNIQUE       Ind1741       Ind1741            1           18.6            0.9       0.1 2.114426e-20    NA    X    X            X            X        X        Y        X        Y        X        Y        Y        Y        X        Y        Y        Y        Y        Y        Y        Y        X        X      -99      -99         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y
      73           55         UNIQUE       Ind1742       Ind1742            2           18.6            0.9       0.1 1.192489e-20    NA    X    X            X            X        X        Y        X        Y        X        X        X        Y        Y        Y        Y        Y        X        X        X        Y        X        Y        X        Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y
      74           55          MATCH       Ind1742     Gg22_1692            2           18.6            0.9       0.1           NA  0.99    X    X            X            X        X        Y        X        Y        X        X        X        Y        Y        Y        Y        Y        X        X        X        Y        X        Y        X        Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y
      75           56         UNIQUE       Ind1744       Ind1744            1           18.6            0.9       0.1 5.220394e-20    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        X        X        Y        Y      -99      -99        X        X        X        X        X        X        X        X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X       -99       -99         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      76           57         UNIQUE       Ind1745       Ind1745            1           18.6            0.9       0.1 2.196235e-20    NA    X    X            X            X        X        Y        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        X        X        X        Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y
      77           58         UNIQUE       Ind1747       Ind1747            1           18.6            0.9       0.1 5.556396e-21    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        Y        Y        Y        X        X        X        Y        X        X        X        X        X        Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y
      78           59         UNIQUE       Ind1751       Ind1751            1           18.6            0.9       0.1 1.656813e-22    NA    X    Y            X            X        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        Y        Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X
      79           60         UNIQUE       Ind1752       Ind1752            1           18.6            0.9       0.1 1.023249e-20    NA    X    X            X            X        X        X        Y        Y        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        X        X        Y        X        Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y
      80           61         UNIQUE       Ind1754       Ind1754            1           18.6            0.9       0.1 2.408010e-20    NA    X    X            X            X        X        Y        X        Y        X        Y        X        X        Y        Y        X        Y        X        X        X        Y        Y        Y        X        Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y
      81           62         UNIQUE       Ind1756       Ind1756            1           18.6            0.9       0.1 2.387919e-21    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        X        X        Y        Y        Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y
      82           63         UNIQUE       Ind1762       Ind1762            1           18.6            0.9       0.1 3.132567e-20    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        Y        Y         Y         Y       -99       -99         X         Y         X         X         Y         Y         X         X         X         Y         X         X       -99       -99         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         X
      83           64         UNIQUE       Ind1767       Ind1767            1           18.6            0.9       0.1 1.172560e-20    NA    X    X            X            X        X        X        Y        Y        X        Y        Y        Y        Y        Y        Y        Y        X        Y        X        X        Y        Y        X        X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y       -99       -99         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y       -99       -99         X         Y         X         X         X         Y         Y         Y
      84           65         UNIQUE       Ind1768       Ind1768            1           18.6            0.9       0.1 2.394653e-21    NA    X    Y            X            X        X        Y        X        X        Y        Y        Y        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y
      85           66         UNIQUE       Ind1769       Ind1769            1           18.6            0.9       0.1 1.825989e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        Y        Y        Y        Y        Y        Y        X        Y        X        Y        X        X        Y        Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y
      86           67         UNIQUE       Ind1773       Ind1773            1           18.6            0.9       0.1 1.641564e-21    NA    X    Y            X            X        X        X        X        Y        Y        Y        Y        Y        X        X        X        Y        X        Y        X        X        X        Y        X        Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y
      87           68         UNIQUE       Ind1779       Ind1779            1           18.6            0.9       0.1 1.037002e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        X        Y        Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X
      88           69         UNIQUE       Ind1781       Ind1781            1           18.6            0.9       0.1 1.151638e-20    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        X        Y        X        X        Y        Y        X        Y        X        X        X        Y        X        X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y
      89           70         UNIQUE       Ind1782       Ind1782            1           18.6            0.9       0.1 4.975596e-21    NA    X    Y            X            X        X        Y        Y        Y        X        Y        Y        Y        Y        Y        Y        Y        X        X        X        Y        X        Y        X        X         Y         Y         Y         Y       -99       -99         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y
      90           71         UNIQUE       Ind1783       Ind1783            1           18.6            0.9       0.1 2.151771e-20    NA    X    X            X            X        X        X        Y        Y        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        Y        X        Y         Y         Y         X         X       -99       -99         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y
      91           72         UNIQUE       Ind1784       Ind1784            1           18.6            0.9       0.1 3.466464e-21    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        Y        Y        X        X        X        X        Y        Y        X        Y        X        X        X        X         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y
      92           73         UNIQUE       Ind1786       Ind1786            1           18.6            0.9       0.1 2.410436e-20    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        Y        X        Y        Y        Y        X        X        X        X        X        Y        X        Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y
      93           74         UNIQUE       Ind1787       Ind1787            1           18.6            0.9       0.1 8.948103e-21    NA    X    Y            X            X        X        X        X        Y        X        X        X        X        Y        Y        Y        Y        Y        Y        X        Y        X        Y        X        Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y
      94           75         UNIQUE       Ind1789       Ind1789            4           18.6            0.9       0.1 2.857453e-20    NA    X    X            X            X        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        X        X        X        X        Y        X        Y        X        Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      95           75          MATCH       Ind1789     Gg22_1693            4           18.6            0.9       0.1 2.857453e-20  1.00    X    X            X            X        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        X        X        X        X        Y        X        Y        X        Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      96           75          MATCH       Ind1789     Gg22_1698            4           18.6            0.9       0.1 2.857453e-20  1.00    X    X            X            X        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        X        X        X        X        Y        X        Y        X        Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      97           75          MATCH       Ind1789     Gg22_1691            4           18.6            0.9       0.1           NA  0.99    X    X            X            X        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        X        X        X        X        Y        X        Y        X        Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      98           76         UNIQUE       Ind1802       Ind1802            1           18.6            0.9       0.1 5.961034e-21    NA    X    X            X            X        X        Y        Y        Y        Y        Y        Y        Y        X        Y        Y        Y        X        X        X        Y        X        Y        Y        Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y
      99           77         UNIQUE       Ind1803       Ind1803            1           18.6            0.9       0.1 8.102659e-20    NA    X    Y            X            X        X        Y        X        X        X        X        Y        Y        X        X        X        Y        X        X        X        Y        X        Y        X        X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y       -99       -99         X         Y         X         Y         X         Y         X         X         Y         Y       -99       -99         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y       -99       -99         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X
      100          78         UNIQUE       Ind1804       Ind1804            1           18.6            0.9       0.1 1.533253e-20    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        X        Y        Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y
      101          79         UNIQUE       Ind1810       Ind1810            1           18.6            0.9       0.1 6.809798e-21    NA    X    Y            X            X        X        Y        X        X        X        Y        X        Y        X        Y        Y        Y        X        X        X        Y        X        Y        X        Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X
      102          80         UNIQUE       Ind1811       Ind1811            1           18.6            0.9       0.1 3.468366e-20    NA    X    X            X            X        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        X        X        Y        Y        Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y
      103          81         UNIQUE       Ind1812       Ind1812            1           18.6            0.9       0.1 2.252720e-21    NA    X    Y            X            X        X        Y        X        X        Y        Y        X        X        X        Y        X        X        X        Y        X        X        X        Y        Y        Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         X
      104          82         UNIQUE       Ind1813       Ind1813            1           18.6            0.9       0.1 2.489678e-20    NA    X    Y            X            X        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        X        X        Y        X        X        Y        Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y
      105          83         UNIQUE       Ind1815       Ind1815            1           18.6            0.9       0.1 2.331049e-20    NA    X    Y            X            X        X        Y        X        X        X        Y        X        X        Y        Y        X        Y        X        Y        X        Y        Y        Y        X        Y         X         Y         X         Y       -99       -99         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y
      106          84         UNIQUE       Ind1817       Ind1817            1           18.6            0.9       0.1 7.554788e-21    NA    X    X            X            X        Y        Y        X        Y        X        X        Y        Y        X        Y        X        Y        X        X        Y        Y        X        X        X        Y         Y         Y         X         Y       -99       -99         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y
      107          85         UNIQUE       Ind1818       Ind1818            1           18.6            0.9       0.1 7.653169e-20    NA    X    X            X            X        X        Y        X        X        X        Y        X        X        Y        Y        X        Y        X        Y        X        X        X        Y        X        Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y
      108          86         UNIQUE       Ind1819       Ind1819            1           18.6            0.9       0.1 7.236193e-20    NA    X    X            X            X        X        Y        X        X        X        Y        X        Y        Y        Y        Y        Y        Y        Y        X        X        X        Y        X        Y         X         Y         X         Y       -99       -99         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X
      109          87         UNIQUE       Ind1821       Ind1821            1           18.6            0.9       0.1 3.877506e-20    NA    X    Y            X            X        X        X        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        X        X        Y        X        Y        Y        Y         Y         Y         X         Y       -99       -99         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y
      110          88         UNIQUE       Ind1822       Ind1822            1           18.6            0.9       0.1 2.062885e-20    NA    X    Y            X            X        Y        Y        Y        Y        X        Y        X        Y        X        Y        Y        Y        X        X        X        Y        X        X        Y        Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y
      111          89         UNIQUE       Ind1823       Ind1823            1           18.6            0.9       0.1 7.231340e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y        X        Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y       -99       -99         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y
      112          90         UNIQUE       Ind1824       Ind1824            1           18.6            0.9       0.1 9.352414e-20    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        X        Y        X        X        Y        Y        X        Y        X        X        X        X        Y        Y         X         Y         X         Y       -99       -99         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y       -99       -99         X         X         X         Y         X         Y         X         X       -99       -99         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y       -99       -99         X         X         Y         Y
      113          91         UNIQUE       Ind1825       Ind1825            1           18.6            0.9       0.1 1.967193e-20    NA    X    X            X            X        X        X        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        X        X        Y        X        Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y
      114          92         UNIQUE       Ind1828       Ind1828            1           18.6            0.9       0.1 4.843144e-20    NA    X    X            X            X        Y        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        X        Y        Y         X         X         Y         Y       -99       -99         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y
      115          93         UNIQUE       Ind1829       Ind1829            1           18.6            0.9       0.1 1.038778e-20    NA    X    X            X            X        X        Y        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y         X         Y         X         X       -99       -99         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y
      116          94         UNIQUE       Ind1970       Ind1970            1           18.6            0.9       0.1 7.168122e-21    NA    X    X            X            X        Y        Y        X        X        X        Y        X        X        X        Y        X        Y        Y        Y        X        Y        X        Y        X        X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y
      117          95         UNIQUE       Ind1971       Ind1971            1           18.6            0.9       0.1 1.804937e-20    NA    X    X            X            X        Y        Y        X        X        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        X        X        Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y       -99       -99         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X
      118          96         UNIQUE       Ind1972       Ind1972            1           18.6            0.9       0.1 6.562426e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        Y        Y        X        X        Y        Y        X        Y        X        Y      -99      -99        X        Y         X         Y         X         Y         X         X       -99       -99         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y       -99       -99         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y       -99       -99       -99       -99         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y
      119          97         UNIQUE       Ind1973       Ind1973            1           18.6            0.9       0.1 1.840006e-20    NA    X    X            X            X        X        Y        X        X        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        X        Y        Y        X        Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y
      120          98         UNIQUE       Ind1974       Ind1974            1           18.6            0.9       0.1 2.772287e-20    NA    X    Y            X            X        X        X        X        Y        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X       -99       -99         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y
      121          99         UNIQUE       Ind1975       Ind1975            1           18.6            0.9       0.1 1.628652e-21    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        Y        Y        Y        Y        Y        Y        Y        X        X        X        Y        Y        Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y
      122         100         UNIQUE       Ind1976       Ind1976            2           18.6            0.9       0.1 5.405804e-21    NA    X    Y            X            X        X        Y        X        Y        Y        Y        X        X        X        Y        Y        Y        X        X        X        Y        X        Y        Y        Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y
      123         100          MATCH       Ind1976     Gg22_1622            2           18.6            0.9       0.1 5.405804e-21  1.00    X    Y            X            X        X        Y        X        Y        Y        Y        X        X        X        Y        Y        Y        X        X        X        Y        X        Y        Y        Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y
      124         101         UNIQUE       Ind1977       Ind1977            1           18.6            0.9       0.1 1.486432e-20    NA    X    Y            X            X        X        Y        Y        Y        X        Y        X        X        X        Y        X        X        X        Y        X        X        X        Y        Y        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y
      125         102         UNIQUE       Ind1978       Ind1978            1           18.6            0.9       0.1 8.201508e-21    NA    X    X            X            X        X        X        X        Y        X        X        Y        Y        X        X        Y        Y        X        Y        X        Y        X        Y        X        X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y
      126         103         UNIQUE       Ind1979       Ind1979            1           18.6            0.9       0.1 7.697027e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        X        X        Y        Y        Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y
      127         104         UNIQUE       Ind1980       Ind1980            1           18.6            0.9       0.1 8.486425e-21    NA    X    Y            X            X        Y        Y        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        X        X        X        Y        Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y
      128         105         UNIQUE       Ind1981       Ind1981            1           18.6            0.9       0.1 1.022572e-20    NA    X    X            X            X        X        Y        X        X        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y
      129         106         UNIQUE       Ind1982       Ind1982            1           18.6            0.9       0.1 1.384060e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        Y        Y        X        X        Y        Y        X        Y        X        X        X        Y        Y        Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y       -99       -99         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      130         107         UNIQUE       Ind1983       Ind1983            1           18.6            0.9       0.1 4.986702e-21    NA    X    X            X            X        X        Y        X        Y        X        X        Y        Y        X        Y        X        Y        Y        Y        X        X        X        Y        X        Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y
      131         108         UNIQUE       Ind1984       Ind1984            1           18.6            0.9       0.1 1.611509e-20    NA    X    Y            X            X        X        X        Y        Y        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        X        X        X        X        Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y
      132         109         UNIQUE       Ind1985       Ind1985            1           18.6            0.9       0.1 3.093045e-20    NA    X    Y            X            X        Y        Y        Y        Y        X        X        X        X        Y        Y        X        Y        Y        Y        X        Y        X        X        X        Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y
      133         110         UNIQUE       Ind1986       Ind1986            1           18.6            0.9       0.1 1.872975e-20    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        X        X        Y        X        Y        X        X        X        X        X        X        X        Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y
      134         111         UNIQUE       Ind1987       Ind1987            1           18.6            0.9       0.1 4.795565e-20    NA    X    Y            X            X        X        Y        Y        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        X        X        X        Y        X        Y         Y         Y         X         Y         Y         Y         X         X       -99       -99         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X       -99       -99         Y         Y         X         X         X         Y         Y         Y         X         X       -99       -99         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X       -99       -99       -99       -99         Y         Y         X         X       -99       -99         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y       -99       -99         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X       -99       -99         X         X         X         Y
      135         112         UNIQUE       Ind1988       Ind1988            1           18.6            0.9       0.1 2.496538e-21    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        X        X        X        Y        Y        X        X        X        X        X        Y        Y        Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      136         113         UNIQUE       Ind1989       Ind1989            1           18.6            0.9       0.1 1.273726e-20    NA    X    X            X            X        X        X        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        X        X        Y        X        X        X        Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y
      137         114         UNIQUE       Ind1990       Ind1990            1           18.6            0.9       0.1 2.441221e-21    NA    X    Y            X            X        X        X        X        Y        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y
      138         115         UNIQUE       Ind1991       Ind1991            1           18.6            0.9       0.1 2.132145e-20    NA    X    X            X            X        X        Y        Y        Y        Y        Y        X        X        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y
      139         116         UNIQUE       Ind1992       Ind1992            1           18.6            0.9       0.1 4.292119e-21    NA    X    Y            X            X        Y        Y        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        X        X        X        X        X         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y
      140         117         UNIQUE       Ind1993       Ind1993            1           18.6            0.9       0.1 1.024027e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        X        Y        Y        Y        Y        X        X        X        Y        X        X        X        Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y
      141         118         UNIQUE       Ind1994       Ind1994            1           18.6            0.9       0.1 2.541999e-20    NA    X    Y            X            X        X        Y        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X        X        Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y       -99       -99         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y       -99       -99         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y
      142         119         UNIQUE       Ind1995       Ind1995            1           18.6            0.9       0.1 9.316940e-21    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        Y        X        X        Y        Y        X        X        X        Y        X        Y        X        Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y
      143         120         UNIQUE       Ind1996       Ind1996            1           18.6            0.9       0.1 1.528502e-19    NA    X    Y            X            X        Y        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        X        X        X        Y        X        X        Y        Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X       -99       -99         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y       -99       -99         X         Y         X         X         X         Y         Y         Y       -99       -99         X         X         X         Y         Y         Y         Y         Y         X         Y       -99       -99         X         X         X         Y         Y         Y       -99       -99         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y
      144         121         UNIQUE       Ind1997       Ind1997            1           18.6            0.9       0.1 2.971761e-21    NA    X    Y            X            X        Y        Y        X        X        X        X        X        Y        X        X        Y        Y        X        X        X        Y        X        Y        Y        Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y
      145         122         UNIQUE       Ind1998       Ind1998            1           18.6            0.9       0.1 3.098147e-20    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        X        X        X        X        Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y
      146         123         UNIQUE       Ind1999       Ind1999            1           18.6            0.9       0.1 1.273115e-20    NA    X    X            X            X        X        Y        X        Y        X        Y        X        X        X        Y        Y        Y        X        X        X        Y        X        Y        X        Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y
      147         124         UNIQUE       Ind3110       Ind3110            1           18.6            0.9       0.1 8.535800e-23    NA    X    Y            Y            Y        Y        Y        Y        Y        X        Y        X        Y        X        X        X        X        Y        Y        X        Y        X        X        X        X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y       -99       -99         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X       -99       -99         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y
      148         125         UNIQUE       Ind3111       Ind3111            1           18.6            0.9       0.1 8.623236e-23    NA    X    Y            Y            Y        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        X        Y        Y        Y        Y        X        X        Y        Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X
      149         126         UNIQUE       Ind3113       Ind3113            1           18.6            0.9       0.1 3.886562e-22    NA    X    X            Y            Y        Y        Y        X        X        Y        Y        X        Y        X        X        X        X        X        Y        X        Y        Y        Y        X        Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X       -99       -99         X         Y         X         Y       -99       -99         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X       -99       -99         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X
      150         127         UNIQUE       Ind3114       Ind3114            1           18.6            0.9       0.1 1.407245e-23    NA    X    X            Y            Y        X        X        Y        Y        X        X        X        X        X        Y        X        X        Y        Y        X        Y        Y        Y        Y        Y         X         X         X         X       -99       -99         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X
      151         128         UNIQUE       Ind3115       Ind3115            1           18.6            0.9       0.1 3.572796e-23    NA    X    Y            Y            Y        X        Y        Y        Y        X        X        X        Y        X        X        X        X        Y        Y        Y        Y        X        Y        X        Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y
      152         129         UNIQUE       Ind3116       Ind3116            1           18.6            0.9       0.1 3.175113e-22    NA    X    X            Y            Y        Y        Y        X        X        X        Y        X        X        X        X        X        X        X        X        Y        Y        X        X        Y        Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         X         X         X         X         X         Y
      153         130         UNIQUE       Ind3117       Ind3117            1           18.6            0.9       0.1 4.151891e-22    NA    X    Y            Y            Y        Y        Y        X        X        X        Y        X        Y        X        X        X        X        X        Y        X        Y        X        Y        X        Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y
      154         131         UNIQUE       Ind3118       Ind3118            1           18.6            0.9       0.1 1.528221e-22    NA    X    Y            Y            Y        Y        Y        X        X        X        X        X        X        X        X        X        X        X        X        X        Y        X        X        Y        Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y
      155         132         UNIQUE       Ind3119       Ind3119            1           18.6            0.9       0.1 1.098760e-23    NA    X    X            Y            Y        X        Y        X        X        X        X        X        X        X        X        X        X        Y        Y        X        Y        X        Y        X        Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y
      156         133         UNIQUE       Ind3120       Ind3120            1           18.6            0.9       0.1 3.758283e-23    NA    X    Y            X            X        X        X        X        X        X        X        X        X        X        X        X        Y        Y        Y        Y        Y        X        Y        X        Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X
      157         134         UNIQUE       Ind3121       Ind3121            1           18.6            0.9       0.1 2.677868e-23    NA    X    Y            Y            Y        X        Y        X        Y        X        Y        X        X        X        X        X        X        X        Y        X        Y        X        X        X        X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X       -99       -99         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X
      158         135         UNIQUE       Ind3122       Ind3122            1           18.6            0.9       0.1 6.524438e-23    NA    X    Y            X            X        X        Y        X        Y        X        X        X        Y        X        X        X        X        Y        Y        X        X        Y        Y        X        Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X       -99       -99         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X
      159         136         UNIQUE       Ind3123       Ind3123            1           18.6            0.9       0.1 1.817442e-22    NA    X    Y            X            X        Y        Y        X        Y        X        X        X        Y        X        X        X        X        X        Y        X        X        X        Y        X        X         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X       -99       -99         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X
      160         137         UNIQUE       Ind3124       Ind3124            1           18.6            0.9       0.1 3.551471e-23    NA    X    Y            Y            Y        X        Y        Y        Y        X        Y        X        X        X        X        X        Y        Y        Y        X        Y        X        Y        X        X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X       -99       -99         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X
      161         138         UNIQUE       Ind3125       Ind3125            1           18.6            0.9       0.1 1.087813e-22    NA    X    Y            X            X        X        Y        X        X        X        Y        X        Y        X        X        X        X        X        Y        Y        Y        X        X        X        X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y
      162         139         UNIQUE       Ind3126       Ind3126            1           18.6            0.9       0.1 2.256218e-23    NA    X    Y            Y            Y        X        Y        Y        Y        X        X        X        Y        X        X        X        X        Y        Y        X        Y        X        Y        X        Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         X
      163         140         UNIQUE       Ind3127       Ind3127            1           18.6            0.9       0.1 6.647726e-24    NA    X    Y            Y            Y        X        Y        X        X        X        Y        X        Y        X        X        X        Y        Y        Y        X        Y        Y        Y        X        X         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y
      164         141         UNIQUE       Ind3128       Ind3128            1           18.6            0.9       0.1 1.509660e-21    NA    X    X            X            X        X        Y        Y        Y        X        X        Y        Y        X        X        Y        Y        Y        Y        X        Y        X        X        X        X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y       -99       -99         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y
      165         142         UNIQUE       Ind3129       Ind3129            1           18.6            0.9       0.1 2.910452e-24    NA    X    Y            Y            Y        X        Y        X        X        X        Y        X        X        X        X        X        X        Y        Y        X        X        X        X        X        X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y
      166         143         UNIQUE       Ind3130       Ind3130            1           18.6            0.9       0.1 1.381738e-22    NA    X    Y            Y            Y        X        Y        X        X        X        Y        X        X        X        Y        X        X        X        Y        Y        Y        X        Y        X        Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y
      167         144         UNIQUE       Ind3131       Ind3131            1           18.6            0.9       0.1 8.523918e-22    NA    X    X            X            X        X        Y        Y        Y        X        X        X        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y
      168         145         UNIQUE       Ind3132       Ind3132            1           18.6            0.9       0.1 5.662815e-24    NA    X    Y            Y            Y        X        X        X        Y        X        Y        X        X        X        X        X        X        Y        Y        X        Y        X        Y        X        X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X
      169         146         UNIQUE       Ind3133       Ind3133            1           18.6            0.9       0.1 1.984362e-23    NA    X    X            Y            Y        Y        Y        X        Y        X        Y        X        Y        X        X        X        Y        Y        Y        X        X        X        X        Y        Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y
      170         147         UNIQUE       Ind3134       Ind3134            1           18.6            0.9       0.1 8.716016e-23    NA    X    Y            Y            Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y
      171         148         UNIQUE       Ind3135       Ind3135            1           18.6            0.9       0.1 3.278332e-24    NA    X    X            Y            Y        X        X        Y        Y        X        X        X        X        X        Y        X        X        Y        Y        X        Y        Y        Y        X        X         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y
      172         149         UNIQUE       Ind3136       Ind3136            1           18.6            0.9       0.1 2.895049e-23    NA    X    Y            Y            Y        Y        Y        X        X        Y        Y        X        X        X        X        X        X        Y        Y        Y        Y        X        Y        X        X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y
      173         150         UNIQUE       Ind3137       Ind3137            1           18.6            0.9       0.1 1.962489e-23    NA    X    X            Y            Y        X        Y        Y        Y        X        Y        Y        Y        X        X        X        X        Y        Y        X        X        X        Y        Y        Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y
      174         151         UNIQUE       Ind3138       Ind3138            1           18.6            0.9       0.1 6.134034e-24    NA    X    Y            Y            Y        X        X        X        Y        X        X        X        X        X        X        X        X        Y        Y        X        Y        Y        Y        Y        Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y
      175         152         UNIQUE       Ind3139       Ind3139            1           18.6            0.9       0.1 9.072505e-24    NA    X    Y            Y            Y        X        Y        X        Y        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        Y        Y        Y        Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y
      176         153         UNIQUE       Ind3140       Ind3140            1           18.6            0.9       0.1 1.685625e-24    NA    X    Y            Y            Y        X        Y        X        X        X        Y        X        Y        Y        Y        X        X        Y        Y        X        Y        Y        Y        X        Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y
      177         154         UNIQUE       Ind3141       Ind3141            1           18.6            0.9       0.1 1.233177e-23    NA    X    X            Y            Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        Y        Y        X        Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         X
      178         155         UNIQUE       Ind3142       Ind3142            1           18.6            0.9       0.1 3.587951e-22    NA    X    Y            Y            Y        Y        Y        X        X        Y        Y        X        X        X        Y        X        X        X        X        X        Y        X        Y        Y        Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y
      179         156         UNIQUE       Ind3143       Ind3143            1           18.6            0.9       0.1 5.372983e-24    NA    X    X            Y            Y        X        X        Y        Y        X        X      -99      -99        X        Y        Y        Y        Y        Y        Y        Y        X        X        X        Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X       -99       -99         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y       -99       -99         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y       -99       -99         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X
      180         157         UNIQUE       Ind3144       Ind3144            1           18.6            0.9       0.1 1.275635e-24    NA    X    Y            Y            Y        X        X        Y        Y        X        X        X        X        X        X        X        X        Y        Y        Y        Y        X        Y        X        X         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y
      181         158         UNIQUE       Ind3145       Ind3145            1           18.6            0.9       0.1 3.169439e-23    NA    X    X            Y            Y        X        Y        Y        Y        X        X        X        Y        X        X        X        X        Y        Y        X        X        Y        Y        X        X         X         X         X         X         Y         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         X         X         Y
      182         159         UNIQUE       Ind3146       Ind3146            1           18.6            0.9       0.1 2.746329e-24    NA    X    Y            Y            Y        X        Y        X        Y        X        X        X        X        X        X        X        X        Y        Y        X        Y        Y        Y        X        X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y
      183         160         UNIQUE       Ind3147       Ind3147            1           18.6            0.9       0.1 6.562976e-24    NA    X    Y            Y            Y        X        Y        X        Y        X        X        X        X        X        X        X        X        Y        Y        X        Y        X        X        X        X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y
      184         161         UNIQUE       Ind3148       Ind3148            1           18.6            0.9       0.1 5.438553e-24    NA    X    Y            Y            Y        X        Y        Y        Y        X        X        X        Y        X        X        X        X        Y        Y        X        X        X        Y        Y        Y         X         X         X         Y       -99       -99         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y
      185         162         UNIQUE       Ind3149       Ind3149            1           18.6            0.9       0.1 2.685964e-23    NA    X    X            Y            Y        Y        Y        Y        Y        X        Y        X        Y        X        X        X        X        Y        Y        X        X      -99      -99        X        X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y       -99       -99         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y       -99       -99         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y       -99       -99         X         X         Y         Y
      186         163         UNIQUE       Ind3850       Ind3850            1           18.6            0.9       0.1 4.693731e-21    NA    X    X            X            X        X        Y        X        X        Y        Y        X        X        Y        Y        Y        Y        X        Y        X        X        X        X        X        Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y
      187         164         UNIQUE       Ind3851       Ind3851            1           18.6            0.9       0.1 2.696085e-20    NA    X    X            X            X        X        X        Y        Y        X        Y        X        X        Y        Y        Y        Y        X        Y        X        Y        X        X        X        Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y       -99       -99         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y
      188         165         UNIQUE       Ind3852       Ind3852            1           18.6            0.9       0.1 2.807567e-20    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y
      189         166         UNIQUE       Ind3853       Ind3853            1           18.6            0.9       0.1 8.857120e-21    NA    X    X            X            X        Y        Y        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        X        X        X        X        X        X        X         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y
      190         167         UNIQUE       Ind3854       Ind3854            1           18.6            0.9       0.1 1.910447e-21    NA    X    Y            X            X        X        Y        Y        Y        X        Y        Y        Y        Y        Y        Y        Y        X        Y        X        X        Y        Y        X        Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y
      191         168         UNIQUE       Ind3855       Ind3855            1           18.6            0.9       0.1 5.280460e-21    NA    X    X            X            X        X        X        Y        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        X        X        Y        Y        Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y
      192         169         UNIQUE       Ind3856       Ind3856            1           18.6            0.9       0.1 1.349509e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        X        X        X        X        X        X        Y         X         X         X         X         X         X         X         Y         Y         Y         Y         Y       -99       -99         Y         Y         X         Y         X         X         X         Y       -99       -99         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X       -99       -99         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y       -99       -99         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y       -99       -99         X         Y
      193         170         UNIQUE       Ind3857       Ind3857            1           18.6            0.9       0.1 7.228259e-21    NA    X    X            X            X        X        Y        Y        Y        X        Y        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        X        X        Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y
      194         171         UNIQUE       Ind3858       Ind3858            1           18.6            0.9       0.1 3.008180e-20    NA    X    X            X            X        X        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        Y        Y        Y        Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y
      195         172         UNIQUE       Ind3859       Ind3859            1           18.6            0.9       0.1 7.835834e-22    NA    X    X            X            X        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        X        Y        Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y
      196         173         UNIQUE       Ind3860       Ind3860            1           18.6            0.9       0.1 1.040002e-20    NA    X    Y            X            X        X        X        X        Y        X        X        X        X        Y        Y        Y        Y        X        X        X        Y        X        X        X        X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y
      197         174         UNIQUE       Ind3861       Ind3861            1           18.6            0.9       0.1 7.499811e-21    NA    X    X            X            X        X        Y        X        X        Y        Y        X        X        X        X        Y        Y        X        Y        X        Y        X        Y        Y        Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y
      198         175         UNIQUE       Ind3862       Ind3862            1           18.6            0.9       0.1 7.617627e-21    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        X        X        Y        X        Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y
      199         176         UNIQUE       Ind3863       Ind3863            1           18.6            0.9       0.1 1.155377e-20    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        X        Y        Y        Y        Y        X        Y        X        Y        X        Y        Y        Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y
      200         177         UNIQUE       Ind4004       Ind4004            1           18.6            0.9       0.1 4.362318e-21    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y        X        X        X        X        X        Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y
      201         178         UNIQUE       Ind4010       Ind4010            1           18.6            0.9       0.1 1.249477e-21    NA    X    X            X            X        Y        Y        X        X        X        Y        X        Y        Y        Y        X        X        X        Y        X        X        X        X        X        Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y
      202         179         UNIQUE       Ind4025       Ind4025            1           18.6            0.9       0.1 9.085905e-22    NA    X    X            X            X        Y        Y        X        Y        X        X        Y        Y        Y        Y        Y        Y        X        X        X        X        X        X        X        Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y
      203         180         UNIQUE       Ind4026       Ind4026            1           18.6            0.9       0.1 1.701289e-21    NA    X    Y            X            X        Y        Y        Y        Y        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        X        X        Y        Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         Y         Y
      204         181         UNIQUE       Ind4029       Ind4029            1           18.6            0.9       0.1 1.124160e-20    NA    X    X            X            X        X        Y        X        X        X        X        Y        Y        X        Y        Y        Y        Y        Y        X        Y        X        X        X        Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y
      205         182         UNIQUE       Ind4031       Ind4031            1           18.6            0.9       0.1 8.507539e-22    NA    X    X            X            X        X        Y        X        Y        X        X        X        Y        X        X        Y        Y        X        Y        X        Y        X        X        Y        Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y       -99       -99         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X
      206         183         UNIQUE       Ind4033       Ind4033            1           18.6            0.9       0.1 2.934599e-20    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        Y        X        X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X       -99       -99         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y
      207         184         UNIQUE       Ind4036       Ind4036            1           18.6            0.9       0.1 8.298766e-22    NA    X    X            X            X        Y        Y        Y        Y        X        X        Y        Y        X        Y        Y        Y        Y        Y        X        Y        X        X        Y        Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y
      208         185         UNIQUE       Ind4038       Ind4038            1           18.6            0.9       0.1 3.000345e-22    NA    X    Y            X            X        X        X        Y        Y        X        Y        Y        Y        Y        Y        Y        Y        X        X        Y        Y        Y        Y        X        X         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y       -99       -99         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y
      209         186         UNIQUE       Ind4039       Ind4039            1           18.6            0.9       0.1 1.611621e-20    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        X        X        Y        Y        Y        Y        X        Y        X        Y        X        X        X        Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y       -99       -99         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y
      210         187         UNIQUE       Ind4041       Ind4041            1           18.6            0.9       0.1 3.914586e-20    NA    X    Y            X            X        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        X        X        Y         X         Y         X         X       -99       -99         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y       -99       -99         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y
      211         188         UNIQUE       Ind4046       Ind4046            1           18.6            0.9       0.1 4.293398e-21    NA    X    X            X            X        Y        Y        Y        Y        X        Y        Y        Y        Y        Y        Y        Y        X        Y        X        X        X        X        Y        Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y
      212         189         UNIQUE       Ind4047       Ind4047            1           18.6            0.9       0.1 8.428776e-21    NA    X    X            X            X        Y        Y        X        X        X        Y        Y        Y        Y        Y        Y        Y        X        X        X        X        X        Y        X        Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X
      213         190         UNIQUE       Ind4048       Ind4048            1           18.6            0.9       0.1 6.248474e-20    NA    X    Y            X            X        Y        Y        Y        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        X        X        Y        Y        Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y       -99       -99         Y         Y         Y         Y       -99       -99         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y       -99       -99         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         X
      214         191         UNIQUE       Ind4049       Ind4049            1           18.6            0.9       0.1 1.175545e-20    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y       -99       -99         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         X
      215         192         UNIQUE       Ind4050       Ind4050            1           18.6            0.9       0.1 3.418581e-21    NA    X    X            X            X        X        Y        Y        Y        X        Y        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        Y         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y
      216         193         UNIQUE       Ind4051       Ind4051            1           18.6            0.9       0.1 7.740303e-21    NA    X    Y            X            X        Y        Y        Y        Y        X        X        Y        Y        X        X        X        Y        X        X        X        X        X        X        X        X         X         Y         X         Y         X         Y         X         Y       -99       -99         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y
      217         194         UNIQUE       Ind4052       Ind4052            1           18.6            0.9       0.1 1.035042e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        X        X        Y        Y        X        X        Y        Y        Y        Y        X        X        Y        Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y       -99       -99         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y
      218         195         UNIQUE       Ind4053       Ind4053            1           18.6            0.9       0.1 9.442427e-21    NA    X    Y            X            X        Y        Y        Y        Y        Y        Y        X        Y        X        X        X        Y        X        X      -99      -99        X        Y        Y        Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y
      219         196         UNIQUE       Ind4054       Ind4054            1           18.6            0.9       0.1 4.780863e-21    NA    X    Y            X            X        Y        Y        X        X        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        X        X        X        X        X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X
      220         197         UNIQUE       Ind4055       Ind4055            1           18.6            0.9       0.1 4.603982e-21    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        X        Y        X        X        X        X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y
      221         198         UNIQUE       Ind4056       Ind4056            1           18.6            0.9       0.1 6.679948e-21    NA    X    Y            X            X        X        Y        Y        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      222         199         UNIQUE       Ind4057       Ind4057            1           18.6            0.9       0.1 2.173026e-21    NA    X    X            X            X        Y        Y        X        Y        X        Y        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        X        Y        Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y
      223         200         UNIQUE       Ind4058       Ind4058            1           18.6            0.9       0.1 5.735293e-21    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        X        Y        Y        Y        X        X        Y        Y        X        X        X        Y        Y        Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y
      224         201         UNIQUE       Ind4059       Ind4059            1           18.6            0.9       0.1 1.259642e-20    NA    X    Y            X            X        Y        Y        X        Y        X        X        X        X        Y        Y        X        X        X        Y        X        X        X        Y        Y        Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y
      225         202         UNIQUE       Ind4060       Ind4060            1           18.6            0.9       0.1 5.287641e-21    NA    X    X            X            X        X        Y        Y        Y        X        Y        X        X        X        Y        Y        Y        X        X        Y        Y        X        X        X        Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X
      226         203         UNIQUE       Ind4061       Ind4061            1           18.6            0.9       0.1 8.805798e-21    NA    X    Y            X            X        X        Y        Y        Y        X        Y        Y        Y        X        Y        Y        Y        X        X        X        X        X        Y        X        Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y
      227         204         UNIQUE       Ind4062       Ind4062            1           18.6            0.9       0.1 5.459729e-21    NA    X    Y            X            X        Y        Y        Y        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        X        X        X        X        Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y
      228         205         UNIQUE       Ind4063       Ind4063            1           18.6            0.9       0.1 1.188352e-21    NA    X    X            X            X        Y        Y        X        Y        X        X        Y        Y        X        Y        Y        Y        X        X        X        X        X        X        X        Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y       -99       -99         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         Y         Y
      229         206         UNIQUE       Ind4064       Ind4064            1           18.6            0.9       0.1 2.819643e-20    NA    X    X            X            X        Y        Y        X        Y        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        Y        Y         Y         Y         Y         Y       -99       -99         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X
      230         207         UNIQUE       Ind4065       Ind4065            1           18.6            0.9       0.1 2.272919e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        Y        Y        Y        Y        Y        Y        X        X        X        X        X        X        Y        Y         X         X         Y         Y       -99       -99         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y       -99       -99         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y       -99       -99         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y
      231         208         UNIQUE       Ind4066       Ind4066            1           18.6            0.9       0.1 3.648315e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        X      -99      -99        Y        Y        X        Y        Y        Y        X        X        X        Y         X         Y         X         Y       -99       -99         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y
      232         209         UNIQUE       Ind4067       Ind4067            1           18.6            0.9       0.1 4.763970e-21    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        Y        Y        Y        Y        Y        Y        X        X        X        Y        X        X        X        X         X         Y         X         Y       -99       -99         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y
      233         210         UNIQUE       Ind4068       Ind4068            1           18.6            0.9       0.1 1.850342e-21    NA    X    X            X            X        Y        Y        Y        Y        Y        Y        Y        Y        X        X        Y        Y        X        X        X        X        X        X        Y        Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      234         211         UNIQUE       Ind4069       Ind4069            1           18.6            0.9       0.1 8.050264e-21    NA    X    X            X            X        X        Y        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        X        X        Y        X        X        X        Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y
      235         212         UNIQUE       Ind4070       Ind4070            1           18.6            0.9       0.1 4.297286e-21    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X
      236         213         UNIQUE       Ind4071       Ind4071            1           18.6            0.9       0.1 3.892183e-20    NA    X    X            X            X        X        X        X        Y        X        Y        X        Y        X        Y        Y        Y        X        X        X        Y        X        Y        X        Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y       -99       -99         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y       -99       -99         X         X         X         X         X         Y         X         Y       -99       -99         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X
      237         214         UNIQUE       Ind4072       Ind4072            1           18.6            0.9       0.1 1.047286e-20    NA    X    X            X            X        X        X        Y        Y        Y        Y        Y        Y        X        X        Y        Y        X        Y        X        Y        X        X        X        Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X
      238         215         UNIQUE       Ind4073       Ind4073            1           18.6            0.9       0.1 5.980412e-21    NA    X    X            X            X        Y        Y        X        X        Y        Y        Y        Y        Y        Y        Y        Y        X        X        X        X        X        Y        X        Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X
      239         216         UNIQUE       Ind4074       Ind4074            1           18.6            0.9       0.1 3.311478e-21    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        Y        Y        Y        Y        Y        Y        Y        X        X        X        X        X        Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y
      240         217         UNIQUE       Ind4075       Ind4075            1           18.6            0.9       0.1 9.764159e-21    NA    X    X            X            X        X        Y        Y        Y        X        X        X        Y        X        X        Y        Y        X        Y        X        Y        X        X      -99      -99         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y
      241         218         UNIQUE       Ind4076       Ind4076            1           18.6            0.9       0.1 6.635659e-21    NA    X    X            X            X        Y        Y        X        Y        Y        Y        X        Y        X        X        X        X        X        Y        X        Y        X        X        X        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y
      242         219         UNIQUE       Ind4077       Ind4077            1           18.6            0.9       0.1 6.667829e-21    NA    X    X            X            X        Y        Y        X        Y        X        Y        Y        Y        Y        Y        Y        Y        X        Y        X        X        X        Y        X        Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y       -99       -99         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y
      243         220         UNIQUE       Ind4078       Ind4078            1           18.6            0.9       0.1 3.475054e-21    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y
      244         221         UNIQUE       Ind4079       Ind4079            1           18.6            0.9       0.1 7.114174e-22    NA    X    Y            X            X        Y        Y        X        Y        X        X        X        Y        X        Y        Y        Y        X        X        X        X        X        X        X        Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y
      245         222         UNIQUE       Ind4080       Ind4080            1           18.6            0.9       0.1 1.032075e-20    NA    X    X            X            X        X        Y        X        X        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X       -99       -99         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y
      246         223         UNIQUE       Ind4081       Ind4081            1           18.6            0.9       0.1 5.770855e-21    NA    X    Y            X            X        Y        Y        X        X        Y        Y        X        X        Y        Y        X        Y        X        Y        X        X        X        X        X        Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y
      247         224         UNIQUE       Ind4082       Ind4082            1           18.6            0.9       0.1 6.559190e-21    NA    X    X            X            X        X        X        X        X        X        Y        X        Y        X        X        Y        Y        Y        Y        X        Y        X        X        Y        Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y
      248         225         UNIQUE       Ind4083       Ind4083            1           18.6            0.9       0.1 4.561985e-21    NA    X    Y            X            X        X        X        Y        Y        Y        Y        Y        Y        Y        Y        X        Y        X        X        X        Y        X        X        X        Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y
      249         226         UNIQUE       Ind4084       Ind4084            1           18.6            0.9       0.1 1.425332e-20    NA    X    Y            X            X        Y        Y        X        Y        X        X        X        Y        X        Y        Y        Y        X        Y        X        X        X        X        X        X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y       -99       -99         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y       -99       -99         X         Y         X         Y         X         X       -99       -99         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X       -99       -99         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y
      250         227         UNIQUE       Ind4085       Ind4085            1           18.6            0.9       0.1 5.986547e-20    NA    X    X            X            X        Y        Y        Y        Y        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        X        X        Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y       -99       -99         X         Y         X         X         X         Y         X         Y
      251         228         UNIQUE       Ind4086       Ind4086            1           18.6            0.9       0.1 2.151594e-20    NA    X    Y            X            X        X        Y        X        X        X        Y        X        X        Y        Y        X        X        X        Y        X        X        X        Y        X        Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y
      252         229         UNIQUE       Ind4087       Ind4087            1           18.6            0.9       0.1 1.760548e-20    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        Y        X        X        X        Y        X        X        X        Y        X        Y        Y        Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y       -99       -99         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y
      253         230         UNIQUE       Ind4088       Ind4088            1           18.6            0.9       0.1 8.337241e-21    NA    X    Y            X            X        X        Y        X        Y        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        X        X        X        X        Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         X
      254         231         UNIQUE       Ind4089       Ind4089            2           18.6            0.9       0.1 1.957669e-21    NA    X    Y            X            X        X        Y        X        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y       -99       -99         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y
      255         231          MATCH       Ind4089  Gg22_0545*40            2           18.6            0.9       0.1           NA  0.99    X    Y            X            X        X        Y        X        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y
      256         232         UNIQUE       Ind4090       Ind4090            1           18.6            0.9       0.1 1.025031e-20    NA    X    Y            X            X        X        Y        X        Y        X        X        Y        Y        X        Y        Y        Y        X        X        X        X        X        X        X        X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y
      257         233         UNIQUE       Ind4091       Ind4091            1           18.6            0.9       0.1 2.242990e-21    NA    X    X            X            X        X        Y        X        Y        X        Y        Y        Y        X        X        Y        Y        X        Y        X        Y        X        Y        X        Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y
      258         234         UNIQUE       Ind4092       Ind4092            1           18.6            0.9       0.1 4.746062e-21    NA    X    X            X            X        X        Y        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y
      259         235         UNIQUE       Ind4093       Ind4093            1           18.6            0.9       0.1 3.262916e-20    NA    X    X            X            X        X        Y        Y        Y        Y        Y        X        Y        X        X        Y        Y        X        Y        X        Y        X        X        Y        Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y
      260         236         UNIQUE       Ind4094       Ind4094            1           18.6            0.9       0.1 3.679691e-20    NA    X    Y            X            X        X        Y        X        Y        Y        Y        X        Y        Y        Y        Y        Y        X        Y        X        X        X        Y        Y        Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y
      261         237         UNIQUE       Ind4095       Ind4095            1           18.6            0.9       0.1 1.728352e-20    NA    X    Y            X            X        Y        Y        X        Y        X        X        Y        Y      -99      -99        X        X        X        X        X        X        X        X        Y        Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X       -99       -99         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y       -99       -99         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y       -99       -99         X         Y         Y         Y         Y         Y         X         Y
      262         238         UNIQUE       Ind4096       Ind4096            1           18.6            0.9       0.1 7.593752e-21    NA    X    Y            X            X        Y        Y        Y        Y        Y        Y        X        Y        X        X        X        Y        X        X        X        Y        X        X        Y        Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y
      263         239         UNIQUE       Ind4097       Ind4097            1           18.6            0.9       0.1 2.806233e-21    NA    X    Y            X            X        X        Y        X        X        Y        Y        X        X        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y       -99       -99         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y
      264         240         UNIQUE       Ind4098       Ind4098            1           18.6            0.9       0.1 1.258887e-20    NA    X    X            X            X        Y        Y        X        X        Y        Y        X        Y        X        Y        X        X        X        Y        X        Y        Y        Y        Y        Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y       -99       -99         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X
      265         241         UNIQUE       Ind4099       Ind4099            1           18.6            0.9       0.1 9.027877e-21    NA    X    Y            X            X        Y        Y        Y        Y        Y        Y        Y        Y        X        Y        Y        Y        X        X        X        Y        X        X        Y        Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X       -99       -99         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y
      266         242         UNIQUE       Ind4100       Ind4100            1           18.6            0.9       0.1 1.476723e-20    NA    X    X            X            X        Y        Y        X        Y        X        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        X        X        Y        Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      267         243         UNIQUE       Ind4101       Ind4101            1           18.6            0.9       0.1 1.850922e-20    NA    X    Y            X            X        X        Y        X        Y        X        X        X        Y        Y        Y        X        Y        X        Y        Y        Y        Y        Y        Y        Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y       -99       -99         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y       -99       -99         X         X         X         Y         X         Y         X         X         Y         Y       -99       -99         X         Y         X         X         X         X         X         X
      268         244         UNIQUE       Ind4102       Ind4102            1           18.6            0.9       0.1 4.329901e-21    NA    X    X            X            X        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        X        X        X         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y
      269         245         UNIQUE       Ind4103       Ind4103            1           18.6            0.9       0.1 8.520474e-20    NA    X    X            X            X      -99      -99        X        Y        X        Y        Y        Y        X        X        Y        Y        Y        Y      -99      -99        X        Y        X        X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y       -99       -99       -99       -99         X         X         Y         Y         Y         Y         X         Y         X         Y       -99       -99         Y         Y         Y         Y         X         X       -99       -99         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y       -99       -99         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X       -99       -99         X         X       -99       -99         X         Y         X         X         Y         Y         X         X       -99       -99         Y         Y       -99       -99         X         X         X         Y         X         Y
      270         246         UNIQUE       Ind4104       Ind4104            2           18.6            0.9       0.1 5.564924e-21    NA    X    X            X            X        X        Y        Y        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        X        Y        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y
      271         246          MATCH       Ind4104     Gg22_1689            2           18.6            0.9       0.1 5.564924e-21  1.00    X    X            X            X        X        Y        Y        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        X        Y        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y
      272         247         UNIQUE       Ind4105       Ind4105            1           18.6            0.9       0.1 3.034560e-21    NA    X    X            X            X        X        Y        Y        Y        X        Y        Y        Y        X        Y        Y        Y        X        X        X        Y        X        X        Y        Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y
      273         248         UNIQUE       Ind4106       Ind4106            1           18.6            0.9       0.1 1.561878e-20    NA    X    X            X            X        Y        Y        X        Y        Y        Y        X        X        Y        Y        Y        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y
      274         249         UNIQUE       Ind4107       Ind4107            1           18.6            0.9       0.1 9.536773e-21    NA    X    X            X            X        X        Y        Y        Y        X        Y        Y        Y        Y        Y        Y        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X       -99       -99       -99       -99         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y
      275         250         UNIQUE       Ind4108       Ind4108            1           18.6            0.9       0.1 6.526031e-20    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        X        X        X        X        Y        X        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y       -99       -99         Y         Y         X         Y       -99       -99       -99       -99         X         X         X         Y         X         Y       -99       -99         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y
      276         251         UNIQUE       Ind4109       Ind4109            1           18.6            0.9       0.1 1.261201e-20    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y
      277         252         UNIQUE       Ind4110       Ind4110            1           18.6            0.9       0.1 4.622896e-21    NA    X    Y            X            X        Y        Y        Y        Y        X        Y        X        X        Y        Y        Y        Y        Y        Y        X        Y        X        X        X        Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y
      278         253         UNIQUE       Ind4111       Ind4111            1           18.6            0.9       0.1 3.791543e-21    NA    X    X            X            X        X        X        Y        Y        X        X        X        X        Y        Y        Y        Y        X        Y        X        Y        X        X        Y        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y
      279         254         UNIQUE       Ind4112       Ind4112            1           18.6            0.9       0.1 3.998553e-21    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        Y        Y        X        X        Y        Y        X        X        X        Y        X        Y        Y        Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y
      280         255         UNIQUE       Ind4113       Ind4113            1           18.6            0.9       0.1 1.473976e-20    NA    X    Y            X            X        Y        Y        Y        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y
      281         256         UNIQUE       Ind4114       Ind4114            1           18.6            0.9       0.1 1.342634e-20    NA    X    Y            X            X        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        Y        Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y
      282         257         UNIQUE       Ind4115       Ind4115            1           18.6            0.9       0.1 3.966745e-19    NA    X    X            X            X        X        X        Y        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        Y        Y        Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y       -99       -99         Y         Y         X         Y       -99       -99         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y       -99       -99         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y       -99       -99         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y       -99       -99         X         Y         X         Y       -99       -99         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y       -99       -99         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y
      283         258         UNIQUE       Ind4116       Ind4116            1           18.6            0.9       0.1 1.974541e-21    NA    X    X            X            X        X        Y        Y        Y        X        Y        X        Y        Y        Y        Y        Y        Y        Y        X        X        X        Y        X        Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y
      284         259         UNIQUE       Ind4117       Ind4117            1           18.6            0.9       0.1 1.133795e-20    NA    X    X            X            X        X        Y        X        Y        X        X        X        X        X        Y        X        Y        X        Y        X        X        X        X        X        Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y
      285         260         UNIQUE       Ind4118       Ind4118            1           18.6            0.9       0.1 2.669776e-21    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        X        X        X        X        X        X        X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y
      286         261         UNIQUE       Ind4119       Ind4119            1           18.6            0.9       0.1 2.531659e-21    NA    X    Y            X            X        X        Y        X        X        X        Y        X        Y        Y        Y        Y        Y        X        X        X        X        X        Y        X        X         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y       -99       -99         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X
      287         262         UNIQUE       Ind4120       Ind4120            1           18.6            0.9       0.1 5.705366e-20    NA    X    X            X            X        Y        Y        Y        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y      -99      -99        X        Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      288         263         UNIQUE       Ind4121       Ind4121            1           18.6            0.9       0.1 6.704184e-21    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        X        X        Y        Y        Y        X        Y        X        X        X        X        X        Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y
      289         264         UNIQUE       Ind4122       Ind4122            1           18.6            0.9       0.1 2.799824e-20    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        Y        Y        Y        Y        X        X        Y        Y        X        X        X        X        X        X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y       -99       -99         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y
      290         265         UNIQUE       Ind4123       Ind4123            1           18.6            0.9       0.1 1.951832e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y      -99      -99        X        Y        X        Y        X        Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y
      291         266         UNIQUE       Ind4124       Ind4124            1           18.6            0.9       0.1 4.400474e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        X        X        Y         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         X         X         X         Y         Y
      292         267         UNIQUE       Ind4125       Ind4125            1           18.6            0.9       0.1 1.756664e-21    NA    X    X            X            X        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y
      293         268         UNIQUE       Ind4126       Ind4126            1           18.6            0.9       0.1 5.160707e-21    NA    X    X            X            X        X        Y        Y        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        Y        Y        X        X        X        Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y
      294         269         UNIQUE       Ind4127       Ind4127            1           18.6            0.9       0.1 1.384602e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        X        X        Y        X        Y        X        Y        Y        Y        X        Y        Y        Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         X
      295         270         UNIQUE       Ind4128       Ind4128            1           18.6            0.9       0.1 1.799522e-20    NA    X    X            X            X        X        X        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        Y        Y        X        X        X        X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X       -99       -99         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X       -99       -99         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y
      296         271         UNIQUE       Ind5000       Ind5000            1           18.6            0.9       0.1 2.066240e-20    NA    X    Y            X            X        X        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        X        X        X        X        Y        Y        X        X         Y         Y         Y         Y       -99       -99         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y
      297         272         UNIQUE       Ind5001       Ind5001            1           18.6            0.9       0.1 1.798144e-20    NA    X    Y            X            X        X        X        X        X        X        X        X        Y        X        X        X        Y        X        X        X        Y        X        X        X        X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y       -99       -99         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y
      298         273         UNIQUE       Ind5002       Ind5002            1           18.6            0.9       0.1 2.095401e-20    NA    X    X            X            X        X        Y        X        X        X        Y        X        X      -99      -99        Y        Y        X        X        X        Y        X        X        X        Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X       -99       -99         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y       -99       -99         X         X         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X       -99       -99         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y
      299         274         UNIQUE       Ind5003       Ind5003            1           18.6            0.9       0.1 3.925849e-21    NA    X    X            X            X        X        Y        X        X        X        Y        X        X        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y
      300         275         UNIQUE       Ind5004       Ind5004            1           18.6            0.9       0.1 6.742912e-21    NA    X    X            X            X        X        X        Y        Y        Y        Y        X        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        Y        Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y
      301         276         UNIQUE       Ind5005       Ind5005            1           18.6            0.9       0.1 1.496334e-21    NA    X    Y            X            X        X        Y        Y        Y        X        Y        Y        Y        X        X        X        Y        X        X        Y        Y        Y        Y        X        Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y
      302         277         UNIQUE       Ind5006       Ind5006            1           18.6            0.9       0.1 1.200010e-21    NA  -99  -99            X            X        X        X        X        Y        Y        Y        X        Y        X        X        X        Y        X        Y        Y        Y        X        Y        X        X         X         X         X         Y         X         X       -99       -99         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         Y         Y
      303         278         UNIQUE       Ind5007       Ind5007            1           18.6            0.9       0.1 8.735070e-21    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        Y        X        Y        X        X        Y        Y        Y        Y        X        Y        X        Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         Y         Y
      304         279         UNIQUE       Ind5008       Ind5008            1           18.6            0.9       0.1 1.375881e-20    NA    X    X            X            X        X        Y        X        X        X        Y        X        X        Y        Y        X        Y        X        X        X        X        X        Y        X        Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y
      305         280         UNIQUE       Ind5009       Ind5009            1           18.6            0.9       0.1 4.937169e-21    NA    X    X            X            X        X        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y
      306         281         UNIQUE       Ind5010       Ind5010            1           18.6            0.9       0.1 1.869333e-20    NA    X    X            X            X        Y        Y        Y        Y        X        Y        X        Y        X        X        X        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X
      307         282         UNIQUE       Ind5011       Ind5011            1           18.6            0.9       0.1 8.982955e-22    NA    X    X            X            X        X        Y        Y        Y        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        X        X        X        Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y
      308         283         UNIQUE       Ind5012       Ind5012            1           18.6            0.9       0.1 1.972529e-20    NA    X    X            X            X        X        X        X        Y        X        X        X        X        X        Y        X        X        X        X        X        X        X        Y        Y        Y       -99       -99         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X       -99       -99         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X       -99       -99         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y       -99       -99         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y
      309         284         UNIQUE       Ind5013       Ind5013            1           18.6            0.9       0.1 2.404657e-20    NA    X    X            X            X        Y        Y        X        Y        X        Y        X        Y        X        X        X        X        X        X        Y        Y        X        Y        X        X         X         Y         Y         Y         X         Y         Y         Y       -99       -99         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X       -99       -99         Y         Y         X         X       -99       -99         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y       -99       -99         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X       -99       -99         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y
      310         285         UNIQUE       Ind5014       Ind5014            1           18.6            0.9       0.1 6.691471e-21    NA    X    X            X            X        X        Y        X        X        Y        Y        X        Y        Y        Y        X        X        X        X        X        Y        X        X        Y        Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y
      311         286         UNIQUE       Ind5015       Ind5015            1           18.6            0.9       0.1 9.481909e-22    NA    X    X            X            X        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        X        X        Y        X        X        X        X        X        Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X
      312         287         UNIQUE       Ind5016       Ind5016            1           18.6            0.9       0.1 7.866821e-21    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        X        Y        Y        Y        Y        Y        X        X        X        X        Y        Y        X        Y       -99       -99         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y
      313         288         UNIQUE       Ind5017       Ind5017            1           18.6            0.9       0.1 4.955214e-21    NA    X    Y            X            X        Y        Y        X        Y        X        X        X        Y        Y        Y        X        Y        X        X        X        Y        X        X        Y        Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X       -99       -99         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X
      314         289         UNIQUE       Ind5018       Ind5018            1           18.6            0.9       0.1 8.351170e-20    NA    X    Y            X            X        X        Y        X        Y        X        X        X        Y        X        X        X        Y      -99      -99        X        Y        X        Y        X        X         X         Y         X         Y         X         Y         X         Y       -99       -99         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y       -99       -99         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y
      315         290         UNIQUE       Ind5019       Ind5019            1           18.6            0.9       0.1 5.090033e-20    NA    X    X            X            X        Y        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X       -99       -99         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y
      316         291         UNIQUE       Ind5020       Ind5020            1           18.6            0.9       0.1 5.783183e-21    NA    X    Y            X            X        X        Y        Y        Y        X        X        X        X        X        X        Y        Y        X        X        X        X        X        X        X        Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X
      317         292         UNIQUE       Ind5021       Ind5021            1           18.6            0.9       0.1 9.939166e-21    NA    X    X            X            X        Y        Y        X        Y        Y        Y        X        Y        Y        Y        X        X        X        Y        X        Y        X        Y        X        Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y
      318         293         UNIQUE       Ind5022       Ind5022            1           18.6            0.9       0.1 5.173907e-21    NA    X    X            X            X        X        X        X        Y        X        Y        X        Y        X        X        X        X        X        Y        X        X        Y        Y        Y        Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y
      319         294         UNIQUE       Ind5023       Ind5023            1           18.6            0.9       0.1 5.514180e-21    NA    X    X            X            X        Y        Y        X        Y        X        Y        Y        Y        Y        Y        Y        Y        X        X        X        X        X        X        X        Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y
      320         295         UNIQUE       Ind5024       Ind5024            1           18.6            0.9       0.1 6.007609e-21    NA    X    Y            X            X        X        Y        X        X        Y        Y        X        Y        X        X        X        X        X        Y        X        X        Y        Y        X        Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y
      321         296         UNIQUE       Ind5025       Ind5025            1           18.6            0.9       0.1 1.160162e-20    NA    X    Y            X            X        X        Y        X        X        Y        Y        X        Y        X        X        X        X        Y        Y        X        Y        X        X        X        X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X
      322         297         UNIQUE       Ind5026       Ind5026            1           18.6            0.9       0.1 1.513790e-20    NA    X    Y            X            X        X        Y        X        X        Y        Y        X        Y        Y        Y        X        X        X        X        X        X        Y        Y        X        Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X
      323         298         UNIQUE       Ind5027       Ind5027            1           18.6            0.9       0.1 9.784467e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        X        X        X        X        Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X       -99       -99         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y       -99       -99         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y
      324         299         UNIQUE       Ind5028       Ind5028            1           18.6            0.9       0.1 3.555305e-20    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        X        Y        Y        X        Y        X        X        X        X        X        Y        X        Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X       -99       -99         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y
      325         300         UNIQUE       Ind5029       Ind5029            1           18.6            0.9       0.1 2.172060e-20    NA    X    X            X            X        X        Y        X        X        X        Y        Y        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y       -99       -99         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         X
      326         301         UNIQUE       Ind5030       Ind5030            1           18.6            0.9       0.1 1.151922e-21    NA    X    X            X            X        X        X        X        X        X        Y        Y        Y        Y        Y        X        X        X        X        X        Y        X        X        X        X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y       -99       -99         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y
      327         302         UNIQUE       Ind5032       Ind5032            1           18.6            0.9       0.1 2.787875e-21    NA    X    X            X            X        Y        Y        Y        Y        X        X        X        X        X        Y        Y        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y
      328         303         UNIQUE       Ind5033       Ind5033            1           18.6            0.9       0.1 1.866082e-21    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        X        Y        X        X        X        Y        X        X        X        Y        Y        Y        Y        Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y       -99       -99         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X       -99       -99         Y         Y         X         X
      329         304         UNIQUE       Ind5034       Ind5034            1           18.6            0.9       0.1 1.494248e-20    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        X        X        Y        Y        Y        X        X        X        Y        X        Y        X        Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y       -99       -99         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y       -99       -99         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y
      330         305         UNIQUE       Ind5035       Ind5035            1           18.6            0.9       0.1 4.423708e-21    NA    X    Y            X            X        X        X        X        X        Y        Y        X        Y        X        Y        X        X        X        X        X        Y        X        Y        X        Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y
      331         306         UNIQUE       Ind5036       Ind5036            1           18.6            0.9       0.1 7.102521e-21    NA    X    Y            X            X        Y        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X
      332         307         UNIQUE       Ind5037       Ind5037            1           18.6            0.9       0.1 1.442883e-21    NA    X    X            X            X        X        Y        X        X        X        Y        Y        Y        X        X        X        X        X        Y        X        Y        X        X        X        X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y
      333         308         UNIQUE       Ind5038       Ind5038            1           18.6            0.9       0.1 2.496542e-21    NA    X    Y            X            X        Y        Y        X        X        X        Y        Y        Y        Y        Y        X        X        Y        Y        X        X        X        Y        Y        Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X
      334         309         UNIQUE       Ind5039       Ind5039            1           18.6            0.9       0.1 6.243663e-21    NA    X    X            X            X        X        Y        X        Y        X        X        X        X        X        Y        X        X        X        Y        X        Y        X        Y        X        X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y       -99       -99         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y       -99       -99         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y
      335         310         UNIQUE       Ind5041       Ind5041            1           18.6            0.9       0.1 2.589255e-20    NA    X    Y            X            X        X        Y        X        X        X        Y        X        Y        X        X        X        Y        X        Y      -99      -99        X        X        Y        Y         X         Y         Y         Y         Y         Y       -99       -99         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         X       -99       -99         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y       -99       -99         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y
      336         311         UNIQUE       Ind5042       Ind5042            1           18.6            0.9       0.1 2.664797e-21    NA    X    X            X            X        Y        Y        Y        Y        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y
      337         312         UNIQUE       Ind5043       Ind5043            1           18.6            0.9       0.1 6.981967e-19    NA    X    Y            X            X      -99      -99        X        Y        X        X        Y        Y        X        X      -99      -99        X        Y        Y        Y        Y        Y      -99      -99       -99       -99         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y       -99       -99         X         X       -99       -99         X         X       -99       -99         X         X         Y         Y         Y         Y         X         X         X         X       -99       -99         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         X         X       -99       -99         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X       -99       -99         X         Y       -99       -99         X         Y         Y         Y         X         X       -99       -99         X         X         X         X         X         X         X         X         Y         Y         Y         Y         X         Y       -99       -99       -99       -99         X         Y         X         X       -99       -99       -99       -99         Y         Y         X         X         X         X         X         X         Y         Y
      338         313         UNIQUE       Ind5045       Ind5045            1           18.6            0.9       0.1 3.809292e-20    NA    X    X            X            X        Y        Y        X        X        X        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y         Y         Y         Y         Y       -99       -99         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X
      339         314         UNIQUE       Ind5046       Ind5046            1           18.6            0.9       0.1 3.247508e-20    NA    X    X            X            X        X        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y        X        X         X         Y         Y         Y       -99       -99         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X
      340         315         UNIQUE       Ind5049       Ind5049            1           18.6            0.9       0.1 4.097649e-21    NA    X    X            X            X        X        X        X        X        X        X        X        Y        X        Y        X        X        X        Y        X        X        Y        Y        X        X         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y
      341         316         UNIQUE       Ind5050       Ind5050            1           18.6            0.9       0.1 8.052677e-21    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        X        X        Y        X        Y        X        Y        Y        Y        X        X        X        X         X         X         X         Y       -99       -99         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X
      342         317         UNIQUE       Ind5051       Ind5051            1           18.6            0.9       0.1 9.844875e-21    NA    X    Y            X            X        X        Y        X        Y        X        X        X        Y        X        Y        X        Y        X        X        X        Y        X        X        X        Y         X         Y         Y         Y       -99       -99         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y
      343         318         UNIQUE       Ind5052       Ind5052            1           18.6            0.9       0.1 3.981759e-21    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y        X        X        X        X        X        Y         X         Y         X         Y       -99       -99         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y
      344         319         UNIQUE       Ind5053       Ind5053            1           18.6            0.9       0.1 2.252469e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        X        X        Y        X        X        X        X        X        Y        X        Y        Y        Y         Y         Y         X         X       -99       -99         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y
      345         320         UNIQUE       Ind5054       Ind5054            1           18.6            0.9       0.1 6.039072e-21    NA    X    Y            X            X        Y        Y        X        Y        X        Y        X        X        X        X        X        Y        X        Y        X        Y        X        X        Y        Y         X         Y         X         Y       -99       -99         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X
      346         321         UNIQUE       Ind5055       Ind5055            1           18.6            0.9       0.1 1.277892e-20    NA    X    Y            X            X        X        Y        X        Y        Y        Y        X        X        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y
      347         322         UNIQUE       Ind5056       Ind5056            1           18.6            0.9       0.1 1.615961e-21    NA    X    X            X            X        X        X        Y        Y        X        X        X        X        X        Y        X        X        X        Y        X        Y        X        X        X        X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y
      348         323         UNIQUE       Ind5057       Ind5057            1           18.6            0.9       0.1 3.900430e-21    NA    X    Y            X            X        X        X        X        Y        X        Y        X        X        X        Y        X        Y        X        Y        Y        Y        X        Y        X        X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y
      349         324         UNIQUE       Ind5058       Ind5058            1           18.6            0.9       0.1 1.688331e-21    NA    X    Y            X            X        X        X        X        Y        X        X        X        X        Y        Y        X        X        X        Y        X        Y        X        X        X        Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y
      350         325         UNIQUE       Ind5059       Ind5059            1           18.6            0.9       0.1 2.520501e-21    NA    X    Y            X            X        X        X        X        X        Y        Y        X        Y        Y        Y        X        X        X        X        X        Y        Y        Y        Y        Y         Y         Y         Y         Y       -99       -99         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y
      351         326         UNIQUE       Ind5060       Ind5060            1           18.6            0.9       0.1 3.260519e-20    NA    X    X            X            X        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        Y        Y        Y        X        Y         X         X         X         X       -99       -99         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y
      352         327         UNIQUE       Ind5061       Ind5061            1           18.6            0.9       0.1 2.744562e-21    NA    X    Y            X            X        X        X        Y        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        X        X        X        X        Y         X         Y         X         Y       -99       -99         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         X
      353         328         UNIQUE       Ind5062       Ind5062            1           18.6            0.9       0.1 4.043799e-21    NA    X    X            X            X        X        Y        Y        Y        X        Y        Y        Y        X        X        X        X        Y        Y        X        X        X        Y        X        X         X         Y         X         X       -99       -99         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y
      354         329         UNIQUE       Ind5063       Ind5063            1           18.6            0.9       0.1 2.389415e-21    NA    X    X            X            X        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X
      355         330         UNIQUE       Ind5064       Ind5064            1           18.6            0.9       0.1 2.844655e-21    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        X        X        Y        X        X        X        Y        X        Y        X        Y        X        X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y
      356         331         UNIQUE       Ind5065       Ind5065            1           18.6            0.9       0.1 9.687511e-21    NA    X    Y            X            X        X        X        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X        X        Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X
      357         332         UNIQUE       Ind5066       Ind5066            1           18.6            0.9       0.1 8.951487e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        Y        Y        X        X        X        X      -99      -99         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y       -99       -99         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y
      358         333         UNIQUE       Ind5067       Ind5067            1           18.6            0.9       0.1 2.597026e-21    NA    X    X            X            X        X        Y        Y        Y        Y        Y        X        X        X        X        X        X        X        Y        X        Y        X        Y        X        Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y
      359         334         UNIQUE       Ind5068       Ind5068            1           18.6            0.9       0.1 2.219096e-19    NA    X    X            X            X        X        Y        X        X        X        Y        X        Y        Y        Y        Y        Y        X        X        X        X        Y        Y        X        X         X         Y         Y         Y       -99       -99         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y       -99       -99         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         X       -99       -99         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y
      360         335         UNIQUE       Ind5069       Ind5069            1           18.6            0.9       0.1 2.002994e-20    NA    X    Y            X            X        Y        Y        X        X        Y        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        Y        Y         X         Y         X         Y       -99       -99         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y
      361         336         UNIQUE       Ind5070       Ind5070            1           18.6            0.9       0.1 6.964467e-21    NA    X    X            X            X        X        Y        X        X        X        X        X        X        Y        Y        X        Y        X        X        X        X        Y        Y        X        X         X         Y         X         Y       -99       -99         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y
      362         337         UNIQUE       Ind5071       Ind5071            1           18.6            0.9       0.1 2.636963e-20    NA    X    Y            X            X        Y        Y        X        X        X        X        Y        Y        Y        Y        Y        Y        X        X        Y        Y        Y        Y        X        Y         Y         Y         X         Y       -99       -99         X         Y       -99       -99         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X
      363         338         UNIQUE       Ind5072       Ind5072            1           18.6            0.9       0.1 5.605633e-21    NA    X    Y            X            X        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y
      364         339         UNIQUE       Ind5073       Ind5073            1           18.6            0.9       0.1 9.659538e-21    NA    X    Y            X            X        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y
      365         340         UNIQUE       Ind5074       Ind5074            1           18.6            0.9       0.1 5.767940e-20    NA    X    X            X            X        Y        Y        X        Y        X        X        X        Y        Y        Y        Y        Y        Y        Y        X        Y        X        Y        X        X         Y         Y         X         Y         Y         Y         X         Y         Y         Y       -99       -99         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y
      366         341         UNIQUE       Ind5075       Ind5075            1           18.6            0.9       0.1 4.532897e-20    NA    X    Y            X            X        X        X        X        X        X        X        X        X        X        Y        X        Y        X        X        X        Y        X        X        X        Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y       -99       -99         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         Y         Y       -99       -99         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         Y
      367         342         UNIQUE       Ind5076       Ind5076            1           18.6            0.9       0.1 5.020921e-22    NA    X    X            X            X        X        X        X        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        X        X        Y        X        Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y
      368         343         UNIQUE       Ind5077       Ind5077            1           18.6            0.9       0.1 1.019733e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        Y        Y        Y        Y        Y        Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y       -99       -99         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y       -99       -99         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X
      369         344         UNIQUE       Ind5078       Ind5078            1           18.6            0.9       0.1 2.130860e-20    NA    X    X            X            X        X        Y        X        X        X        Y        X        Y        X        Y        Y        Y        Y        Y        X        Y        X        X        Y        Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y
      370         345         UNIQUE       Ind5079       Ind5079            1           18.6            0.9       0.1 1.134978e-20    NA    X    Y            X            X        Y        Y        X        X        X        X        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y
      371         346         UNIQUE       Ind5080       Ind5080            1           18.6            0.9       0.1 1.647689e-20    NA    X    Y            X            X        X        Y        X        X        X        X        Y        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y
      372         347         UNIQUE       Ind5081       Ind5081            1           18.6            0.9       0.1 2.664540e-21    NA    X    Y            X            X        X        Y        X        X        X        Y        X        X        X        Y        X        X        Y        Y        X        Y        X        Y        X        X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y
      373         348         UNIQUE       Ind5082       Ind5082            1           18.6            0.9       0.1 4.014739e-17    NA    X    X            X            X        X        Y        X        X        Y        Y        X        X        X        X        X        Y        X        X        X        Y        X        X      -99      -99         X         Y       -99       -99       -99       -99       -99       -99         X         Y         X         Y       -99       -99         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y       -99       -99         X         Y         Y         Y         X         X         X         Y       -99       -99         X         Y         X         Y         Y         Y       -99       -99       -99       -99         X         X         Y         Y         X         X       -99       -99         X         X         X         X         X         X         X         X       -99       -99       -99       -99         Y         Y         X         Y       -99       -99         X         X         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y       -99       -99         Y         Y       -99       -99         Y         Y         X         X         X         X         X         X         X         Y       -99       -99         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y       -99       -99         X         Y         X         X
      374         349         UNIQUE       Ind5083       Ind5083            1           18.6            0.9       0.1 5.847048e-20    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        X        X      -99      -99        X        Y        Y        Y        X        Y        Y        Y      -99      -99         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X       -99       -99         Y         Y         X         X         Y         Y         X         X       -99       -99         X         Y       -99       -99         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X       -99       -99         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y       -99       -99         Y         Y         X         X         X         Y         X         X       -99       -99         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y
      375         350         UNIQUE       Ind5084       Ind5084            1           18.6            0.9       0.1 1.146755e-20    NA    X    X            X            X        Y        Y        Y        Y        X        Y        X        X        X        Y        X        Y        X        Y        X        X        X        X        Y        Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y
      376         351         UNIQUE       Ind5085       Ind5085            1           18.6            0.9       0.1 4.777311e-21    NA    X    Y            X            X        Y        Y        Y        Y        Y        Y        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        X         X         X         Y         Y       -99       -99         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y       -99       -99         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y
      377         352         UNIQUE       Ind5086       Ind5086            1           18.6            0.9       0.1 1.015986e-20    NA    X    Y            X            X        X        Y        Y        Y        Y        Y        X        X        X        X        X        Y        Y        Y        X        Y        Y        Y        Y        Y         X         Y         X         X       -99       -99         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y
      378         353         UNIQUE       Ind5087       Ind5087            1           18.6            0.9       0.1 3.786603e-21    NA    X    X            X            X        X        X        X        Y        X        Y        Y        Y        X        Y        X        X        X        Y        X        X        X        X        X        X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y
      379         354         UNIQUE       Ind5088       Ind5088            1           18.6            0.9       0.1 8.564494e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        X        X        Y        Y        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         Y         Y       -99       -99         X         Y       -99       -99         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y       -99       -99         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y
      380         355         UNIQUE       Ind5089       Ind5089            1           18.6            0.9       0.1 3.593208e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        Y        Y        X        X        X        X         Y         Y         X         X       -99       -99         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y
      381         356         UNIQUE       Ind5090       Ind5090            1           18.6            0.9       0.1 6.731888e-21    NA    X    Y            X            X        X        X        X        X        X        X        X        Y        Y        Y        X        Y        X        X        X        X        X        Y        X        X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y
      382         357         UNIQUE       Ind5091       Ind5091            1           18.6            0.9       0.1 1.348995e-21    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        Y        X        X        Y        Y        X        X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y
      383         358         UNIQUE       Ind5092       Ind5092            1           18.6            0.9       0.1 2.266468e-20    NA    X    X            X            X        X        Y        X        X        Y        Y        Y        Y        X        X        X        Y        X        X        X        X        X        Y        Y        Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y       -99       -99         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y
      384         359         UNIQUE       Ind5093       Ind5093            1           18.6            0.9       0.1 9.508452e-21    NA    X    Y            X            X        X        X        X        X        X        Y        X        X        X        Y        X        X        X        X        X        X        Y        Y        X        Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y
      385         360         UNIQUE       Ind5094       Ind5094            1           18.6            0.9       0.1 4.858154e-20    NA    X    Y            X            X        Y        Y        X        X        Y        Y        X        X        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y       -99       -99         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y       -99       -99         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y
      386         361         UNIQUE       Ind5095       Ind5095            1           18.6            0.9       0.1 4.782289e-20    NA    X    Y            X            X        X        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y       -99       -99         X         Y         Y         Y         X         Y       -99       -99         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y
      387         362         UNIQUE       Ind5096       Ind5096            1           18.6            0.9       0.1 3.864769e-19    NA    X    Y            X            X        Y        Y        X        Y        X        Y        X        Y        Y        Y      -99      -99        X        X        X        Y      -99      -99        Y        Y         Y         Y         X         Y         X         X       -99       -99         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y       -99       -99         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y       -99       -99         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y
      388         363         UNIQUE       Ind5097       Ind5097            1           18.6            0.9       0.1 2.098537e-21    NA    X    Y            X            X        X        Y        Y        Y        X        X        Y        Y        Y        Y        X        X        X        X        X        Y        X        X        X        X         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y
      389         364         UNIQUE       Ind5098       Ind5098            1           18.6            0.9       0.1 1.155392e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        X        X        X        X        X        X        Y        X        Y        X        Y        Y        Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y
      390         365         UNIQUE       Ind5099       Ind5099            1           18.6            0.9       0.1 1.319023e-20    NA    X    Y            X            X        X        X        X        Y        X        Y        X        X        X        Y        X        X        X        X        X        X        Y        Y        X        Y         Y         Y         Y         Y       -99       -99         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X
      391         366         UNIQUE       Ind5100       Ind5100            1           18.6            0.9       0.1 9.125939e-21    NA    X    X            X            X        X        Y        X        X        X        Y        X        X        X        Y        X        X        X        X        X        Y        X        X        X        X         X         Y         X         Y       -99       -99         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y
      392         367         UNIQUE       Ind5101       Ind5101            1           18.6            0.9       0.1 1.357262e-20    NA    X    X            X            X        X        X        X        X        X        X        X        Y        X        Y        X        X        X        X        X        X        X        X        X        X         Y         Y         X         Y       -99       -99         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y
      393         368         UNIQUE       Ind5102       Ind5102            1           18.6            0.9       0.1 8.948720e-21    NA    X    Y            X            X        X        X        X        X        X        X        X        Y        X        X        Y        Y        X        Y        X        X        Y        Y        X        Y         Y         Y         Y         Y       -99       -99         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y
      394         369         UNIQUE       Ind5103       Ind5103            1           18.6            0.9       0.1 6.914625e-21    NA    X    Y            X            X        Y        Y        X        X        X        Y        X        Y        X        Y        Y        Y        X        X        Y        Y        Y        Y        Y        Y         Y         Y         X         X       -99       -99         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X
      395         370         UNIQUE       Ind5104       Ind5104            1           18.6            0.9       0.1 1.773290e-20    NA    X    X            X            X        X        X        X        X        X        Y        X        X        Y        Y        X        X        X        X        X        X        Y        Y        X        Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y       -99       -99         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y
      396         371         UNIQUE       Ind5105       Ind5105            1           18.6            0.9       0.1 1.012336e-19    NA    X    X            X            X        X        X        X        Y        Y        Y        X        X        Y        Y        X        X        X        X        X        X        Y        Y        Y        Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y       -99       -99         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y       -99       -99         X         Y       -99       -99         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y
      397         372         UNIQUE       Ind5106       Ind5106            1           18.6            0.9       0.1 7.348065e-21    NA    X    Y            X            X        X        Y        X        Y        X        X        X        Y        Y        Y        X        X        X        X        Y        Y        X        X        X        X         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y       -99       -99         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y
      398         373         UNIQUE       Ind5107       Ind5107            1           18.6            0.9       0.1 6.255225e-21    NA    X    Y            X            X        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        X        X        X        X        X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X
      399         374         UNIQUE       Ind5108       Ind5108            1           18.6            0.9       0.1 6.860294e-21    NA    X    X            X            X        X        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        X        X        Y        X        X        X        X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X
      400         375         UNIQUE       Ind5109       Ind5109            1           18.6            0.9       0.1 2.836748e-20    NA    X    X            X            X        X        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        X        X        X        X        X        Y        X        X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y       -99       -99         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y
      401         376         UNIQUE       Ind5110       Ind5110            1           18.6            0.9       0.1 7.041217e-24    NA    X    Y            Y            Y        X        Y        Y        Y        X        X        X        X        X        X        X        X        Y        Y        X        Y        X        X        X        Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y
      402         377         UNIQUE       Ind5111       Ind5111            1           18.6            0.9       0.1 6.515068e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        Y        Y         Y         Y       -99       -99         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y
      403         378         UNIQUE       Ind5112       Ind5112            1           18.6            0.9       0.1 2.233794e-21    NA    X    X            X            X        X        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        X        X        Y        X        Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y       -99       -99         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y
      404         379         UNIQUE       Ind5113       Ind5113            1           18.6            0.9       0.1 6.512920e-21    NA    X    X            X            X        X        Y        X        Y        X        Y        X        X        Y        Y        X        X        X        X        X        Y        X        Y        X        Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y
      405         380         UNIQUE       Ind5114       Ind5114            1           18.6            0.9       0.1 5.969870e-21    NA    X    X            X            X        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        X        X        Y        X        X        X        Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y
      406         381         UNIQUE       Ind5115       Ind5115            1           18.6            0.9       0.1 2.595658e-20    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        X        X        X        X        X        Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y       -99       -99         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X       -99       -99         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         Y         Y
      407         382         UNIQUE       Ind5116       Ind5116            1           18.6            0.9       0.1 4.717106e-21    NA    X    X            X            X        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        X        Y        Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y
      408         383         UNIQUE       Ind5117       Ind5117            1           18.6            0.9       0.1 1.440544e-20    NA    X    Y            X            X        X        Y        X        X        X        Y        X        Y        Y        Y        X        Y        X        X        X        Y        X        Y        Y        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y
      409         384         UNIQUE       Ind5118       Ind5118            1           18.6            0.9       0.1 2.953271e-21    NA    X    X            X            X        Y        Y        X        X        X        X        X        Y        X        Y        X        X        X        Y        X        X        Y        Y        X        Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y
      410         385         UNIQUE       Ind5119       Ind5119            1           18.6            0.9       0.1 1.781385e-20    NA    X    Y            X            X        X        X        X        X        X        X        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y       -99       -99         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X
      411         386         UNIQUE       Ind5120       Ind5120            1           18.6            0.9       0.1 4.750250e-21    NA    X    X            X            X        X        Y        X        Y        X        X        X        X        X        Y        X        X        X        Y        X        Y        Y        Y        X        Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y
      412         387         UNIQUE       Ind5121       Ind5121            1           18.6            0.9       0.1 2.840409e-20    NA    X    X            X            X        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        Y        Y        X        Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y       -99       -99         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y
      413         388         UNIQUE       Ind5122       Ind5122            1           18.6            0.9       0.1 9.074565e-21    NA    X    X            X            X        X        X        X        Y        X        Y        X        X        X        Y        X        Y        X        Y        Y        Y        X        X        X        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y       -99       -99         X         X         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y
      414         389         UNIQUE       Ind5123       Ind5123            1           18.6            0.9       0.1 3.065180e-20    NA    X    X            X            X        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        Y        Y        X        X        X        Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X       -99       -99         X         Y
      415         390         UNIQUE       Ind5124       Ind5124            1           18.6            0.9       0.1 9.008096e-20    NA    X    X            X            X        X        X        Y        Y        Y        Y        X        X        X        X        X        Y        X        X        Y        Y        X        Y        Y        Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y       -99       -99         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y       -99       -99         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X       -99       -99         X         Y         X         X       -99       -99         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y       -99       -99         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y
      416         391         UNIQUE       Ind5125       Ind5125            1           18.6            0.9       0.1 3.540078e-20    NA    X    X            X            X        Y        Y        X        Y        X        Y        X        Y        X        X        Y        Y        X        Y        X        Y        X        X        X        X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y       -99       -99         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y
      417         392         UNIQUE       Ind5126       Ind5126            1           18.6            0.9       0.1 1.923321e-20    NA    X    Y            X            X        X        X        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X        X        X        Y        Y        X        Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X       -99       -99         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y
      418         393         UNIQUE       Ind5127       Ind5127            1           18.6            0.9       0.1 4.178184e-21    NA    X    Y            X            X        X        Y        Y        Y        X        X        X        Y        X        X        X        Y        X        X        Y        Y        X        Y        X        X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         Y
      419         394         UNIQUE       Ind5128       Ind5128            1           18.6            0.9       0.1 1.147914e-20    NA    X    X            X            X        X        Y        Y        Y        X        X        Y        Y        Y        Y        X        X        X        Y        X        X        X        Y        X        X         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X       -99       -99         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X       -99       -99         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y
      420         395         UNIQUE       Ind5129       Ind5129            1           18.6            0.9       0.1 1.671841e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X
      421         396         UNIQUE       Ind5130       Ind5130            1           18.6            0.9       0.1 2.219718e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        Y        Y        X        Y        Y        Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y       -99       -99         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y
      422         397         UNIQUE       Ind5131       Ind5131            1           18.6            0.9       0.1 1.511210e-21    NA    X    Y            X            X        X        Y        Y        Y        X        Y        X        X        X        X        X        X        Y        Y        X        X        X        Y        X        X         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y
      423         398         UNIQUE       Ind5132       Ind5132            1           18.6            0.9       0.1 6.727790e-21    NA    X    Y            X            X      -99      -99        X        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X       -99       -99         X         Y         X         Y         X         X       -99       -99         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X
      424         399         UNIQUE       Ind5133       Ind5133            1           18.6            0.9       0.1 9.934028e-21    NA    X    X            X            X        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        X        X        X        X        X        X        X        Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y       -99       -99         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X
      425         400         UNIQUE       Ind5134       Ind5134            1           18.6            0.9       0.1 1.805891e-20    NA    X    X            X            X        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        Y        Y        X        X         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y
      426         401         UNIQUE       Ind5135       Ind5135            1           18.6            0.9       0.1 9.022765e-21    NA    X    Y            X            X        Y        Y        Y        Y        X        X        X        Y        X        X        Y        Y        X        Y        X        X        X        Y        Y        Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         Y         Y
      427         402         UNIQUE       Ind5136       Ind5136            1           18.6            0.9       0.1 1.906999e-21    NA    X    X            X            X        X        Y        Y        Y        X        X        Y        Y        X        Y        Y        Y        X        Y        Y        Y        X        X        X        Y         Y         Y       -99       -99         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y       -99       -99         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y
      428         403         UNIQUE       Ind5137       Ind5137            1           18.6            0.9       0.1 8.682182e-22    NA    X    Y            X            X        X        X        X        X        X        X        X        Y        Y        Y        Y        Y        X        X        X        Y        X        Y        X        X         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y
      429         404         UNIQUE       Ind5138       Ind5138            1           18.6            0.9       0.1 2.806095e-21    NA    X    X            X            X        X        X        X        Y        X        X        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X
      430         405         UNIQUE       Ind5139       Ind5139            1           18.6            0.9       0.1 4.572500e-21    NA    X    Y            X            X        X        Y        Y        Y        X        X        X        X        Y        Y        Y        Y        Y        Y        X        X        X        Y        X        Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X
      431         406         UNIQUE       Ind5140       Ind5140            1           18.6            0.9       0.1 6.949039e-21    NA    X    X            X            X        Y        Y        X        Y        X        Y        X        X        X        Y        Y        Y        X        X        X        X        Y        Y        X        Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y       -99       -99         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X       -99       -99         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X       -99       -99         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         X
      432         407         UNIQUE       Ind5141       Ind5141            1           18.6            0.9       0.1 1.001305e-21    NA    X    X            X            X        X        X        X        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        X        X        X        Y        Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X
      433         408         UNIQUE       Ind5142       Ind5142            1           18.6            0.9       0.1 3.105476e-20    NA    X    X            X            X        Y        Y        X        X        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        X        Y        Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y       -99       -99         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X
      434         409         UNIQUE       Ind5143       Ind5143            1           18.6            0.9       0.1 8.010950e-21    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        X        X        Y        X        Y        Y        Y        X        X        X        Y        X        X         X         Y         X         X         X         Y       -99       -99         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y       -99       -99         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y
      435         410         UNIQUE       Ind5144       Ind5144            1           18.6            0.9       0.1 2.428972e-21    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        X        X        Y        Y        Y        X        Y        Y        Y        X        Y        Y        Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y
      436         411         UNIQUE       Ind5145       Ind5145            1           18.6            0.9       0.1 1.814737e-21    NA    X    Y            X            X        Y        Y        Y        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        X        X        X        Y        X        X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         X         X         X         X         X         X         X         X         X         Y       -99       -99         X         Y         X         Y
      437         412         UNIQUE       Ind5146       Ind5146            1           18.6            0.9       0.1 5.212511e-21    NA    X    Y            X            X        X        Y        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y
      438         413         UNIQUE       Ind5147       Ind5147            1           18.6            0.9       0.1 1.075683e-20    NA    X    X            X            X        Y        Y        Y        Y        X        Y        X        Y        X        X        X        Y        X        Y        X        X        X        Y        X        X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y
      439         414         UNIQUE       Ind5148       Ind5148            1           18.6            0.9       0.1 9.094613e-22    NA    X    X            X            X        Y        Y        X        Y        X        X        X        Y        X        Y        Y        Y        Y        Y        X        X        X        X        X        Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y
      440         415         UNIQUE       Ind5149       Ind5149            1           18.6            0.9       0.1 9.437321e-21    NA    X    X            X            X        X        X        Y        Y        X        Y        X        X        X        Y        X        Y        X        Y        X        X        X        X        X        Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y
      441         416         UNIQUE       Ind5150       Ind5150            1           18.6            0.9       0.1 1.073772e-20    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        X        Y        Y        Y        X        X        X        Y        X        X        Y        Y        Y        Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y
      442         417         UNIQUE       Ind5151       Ind5151            1           18.6            0.9       0.1 5.073499e-21    NA    X    X            X            X        X        X        X        X        X        X        X        Y        Y        Y        Y        Y        X        X        X        X        Y        Y        X        X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X
      443         418         UNIQUE       Ind5152       Ind5152            1           18.6            0.9       0.1 4.618470e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        Y        Y        X        Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y
      444         419         UNIQUE       Ind5153       Ind5153            1           18.6            0.9       0.1 2.392050e-20    NA    X    Y            X            X        Y        Y        Y        Y        X        Y        X        X        Y        Y        X        X        X        Y        X        Y        X        X        X        Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y
      445         420         UNIQUE       Ind5154       Ind5154            1           18.6            0.9       0.1 2.721478e-20    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        X         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y       -99       -99         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y
      446         421         UNIQUE       Ind5155       Ind5155            1           18.6            0.9       0.1 3.887277e-20    NA    X    Y            X            X        Y        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        Y        X        Y         Y         Y         X         X       -99       -99         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y       -99       -99         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y
      447         422         UNIQUE       Ind5156       Ind5156            1           18.6            0.9       0.1 1.423086e-20    NA    X    Y            X            X        X        Y        X        Y        X        X        Y        Y        Y        Y        X        Y        X        X        X        Y        X        Y        Y        Y         Y         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         Y       -99       -99         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y
      448         423         UNIQUE       Ind5157       Ind5157            1           18.6            0.9       0.1 2.246501e-20    NA    X    X            X            X        Y        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        X        X        X        Y        Y        Y      -99      -99         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y
      449         424         UNIQUE       Ind5158       Ind5158            1           18.6            0.9       0.1 2.301139e-20    NA    X    Y            X            X        X        X        X        X        X        X        X        Y        Y        Y        X        Y        X        X        X        X        X        Y        X        X         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y       -99       -99         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y
      450         425         UNIQUE       Ind5159       Ind5159            1           18.6            0.9       0.1 8.180674e-21    NA    X    X            X            X        X        Y        X        Y        Y        Y        Y        Y        X        X        X        X        X        Y        X        Y        X        Y        Y        Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y
      451         426         UNIQUE       Ind5160       Ind5160            1           18.6            0.9       0.1 3.141349e-21    NA    X    Y            X            X        Y        Y        Y        Y        X        X        X        Y        Y        Y        X        Y        X        X        X        Y        X        X        X        Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y
      452         427         UNIQUE       Ind5161       Ind5161            1           18.6            0.9       0.1 3.790719e-20    NA    X    X            X            X        X        Y        X        Y        X        Y        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        X        Y        Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y
      453         428         UNIQUE       Ind5162       Ind5162            2           18.6            0.9       0.1 6.170233e-21    NA    X    Y            X            X        X        Y        X        Y        X        X        Y        Y        X        X        X        Y        X        Y        X        X        X        X        X        Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y
      454         428          MATCH       Ind5162     Gg22_1616            2           18.6            0.9       0.1 6.170233e-21  1.00    X    Y            X            X        X        Y        X        Y        X        X        Y        Y        X        X        X        Y        X        Y        X        X        X        X        X        Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y
      455         429         UNIQUE       Ind5163       Ind5163            1           18.6            0.9       0.1 2.707940e-20    NA    X    X            X            X        X        Y        X        Y        X        Y        X        X        Y        Y        X        X        X        X        X        Y        X        X        X        Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y
      456         430         UNIQUE       Ind5164       Ind5164            1           18.6            0.9       0.1 4.459949e-20    NA    X    X            X            X        Y        Y        X        X        X        Y        Y        Y        Y        Y        X        Y        X        Y        X        X        X        Y        X        Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X       -99       -99         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y
      457         431         UNIQUE       Ind5165       Ind5165            1           18.6            0.9       0.1 3.247805e-20    NA    X    Y            X            X        Y        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         X
      458         432         UNIQUE       Ind5166       Ind5166            1           18.6            0.9       0.1 4.122057e-21    NA    X    Y            X            X        X        Y        X        X        X        X        X        Y        X        X        Y        Y        X        Y        X        X        X        Y        X        Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y
      459         433         UNIQUE       Ind5167       Ind5167            1           18.6            0.9       0.1 9.551582e-21    NA    X    X            X            X        X        Y        X        X        X        X        X        Y        X        Y        X        X        X        Y        X        X        Y        Y        X        X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y
      460         434         UNIQUE       Ind5168       Ind5168            1           18.6            0.9       0.1 6.815826e-21    NA    X    Y            X            X        X        X        Y        Y        X        X        Y        Y        Y        Y        X        X        X        Y        X        X        X        Y        Y        Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y       -99       -99         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X
      461         435         UNIQUE       Ind5169       Ind5169            1           18.6            0.9       0.1 4.396117e-21    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        X        X        Y        X        Y        X        Y        Y        Y        X        X        X        Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y
      462         436         UNIQUE       Ind5170       Ind5170            1           18.6            0.9       0.1 7.475109e-21    NA    X    X            X            X        Y        Y        X        Y        Y        Y        X        X        Y        Y        Y        Y        X        Y        X        Y        X        Y        X        X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y       -99       -99         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X
      463         437         UNIQUE       Ind5171       Ind5171            1           18.6            0.9       0.1 1.365972e-20    NA    X    X            X            X        Y        Y        X        X        X        Y        X        X        Y        Y        X        Y        Y        Y        Y        Y        X        Y        Y        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X       -99       -99         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y
      464         438         UNIQUE       Ind5172       Ind5172            1           18.6            0.9       0.1 3.026906e-21    NA    X    Y            X            X        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        X        Y        Y        X        Y        X        Y        X        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y
      465         439         UNIQUE       Ind5173       Ind5173            1           18.6            0.9       0.1 8.856475e-21    NA    X    X            X            X        X        X        X        X        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        Y        X        Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y
      466         440         UNIQUE       Ind5174       Ind5174            1           18.6            0.9       0.1 4.741000e-21    NA    X    X            X            X        Y        Y        X        Y        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        X        X        X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y
      467         441         UNIQUE       Ind5175       Ind5175            1           18.6            0.9       0.1 5.730198e-21    NA    X    X            X            X        Y        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        Y        Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         X       -99       -99         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X
      468         442         UNIQUE       Ind5176       Ind5176            1           18.6            0.9       0.1 5.124944e-21    NA    X    X            X            X        X        X        X        X        X        Y        X        Y        Y        Y        X        Y        X        X        Y        Y        X        Y        X        Y         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y
      469         443         UNIQUE       Ind5177       Ind5177            1           18.6            0.9       0.1 3.225708e-21    NA    X    X            X            X        X        Y        X        Y        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        Y        Y        Y        X        Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y
      470         444         UNIQUE       Ind5178       Ind5178            1           18.6            0.9       0.1 3.079015e-21    NA    X    X            X            X        X        X        X        Y        X        Y        Y        Y        X        X        Y        Y        X        X        X        Y        Y        Y        Y        Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y
      471         445         UNIQUE       Ind5179       Ind5179            1           18.6            0.9       0.1 1.784895e-21    NA    X    Y            X            X        Y        Y        X        X        X        X        X        X        X        Y        X        Y        Y        Y        X        Y        Y        Y        X        Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y
      472         446         UNIQUE       Ind5180       Ind5180            1           18.6            0.9       0.1 2.085894e-20    NA    X    X            X            X        Y        Y        X        Y        X        Y      -99      -99        Y        Y        X        Y        X        X        X        Y        X        X        X        X         Y         Y         X         Y         X         Y         Y         Y       -99       -99         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y       -99       -99         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y
      473         447         UNIQUE       Ind5181       Ind5181            1           18.6            0.9       0.1 1.151762e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y
      474         448         UNIQUE       Ind5182       Ind5182            1           18.6            0.9       0.1 6.313198e-22    NA    X    Y            X            X        Y        Y        X        X        X        Y        X        X        X        X        X        Y        Y        Y        X        X        X        Y        X        X         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         Y
      475         449         UNIQUE       Ind5183       Ind5183            1           18.6            0.9       0.1 5.683842e-21    NA    X    X            X            X        Y        Y        X        X        X        Y        Y        Y        Y        Y        Y        Y        X        Y        Y        Y        X        X        Y        Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         X
      476         450         UNIQUE       Ind5184       Ind5184            1           18.6            0.9       0.1 4.622258e-20    NA    X    X            X            X        X        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        X        X        X        X        Y        X        Y       -99       -99         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X       -99       -99         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y
      477         451         UNIQUE       Ind5185       Ind5185            1           18.6            0.9       0.1 1.428027e-20    NA    X    Y            X            X        X        Y        X        Y        X        Y        X        X        Y        Y        X        Y        X        Y        X        Y        Y        Y        Y        Y         X         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y       -99       -99         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y
      478         452         UNIQUE       Ind5186       Ind5186            1           18.6            0.9       0.1 3.822744e-21    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        X        Y        Y        X        X        X        Y        Y        Y        X        X        X        X         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y
      479         453         UNIQUE       Ind5187       Ind5187            1           18.6            0.9       0.1 1.728840e-21    NA    X    Y            X            X        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        Y        Y        X        X        X        Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         Y
      480         454         UNIQUE       Ind5188       Ind5188            1           18.6            0.9       0.1 1.591693e-20    NA    X    X            X            X        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        X        X        X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         Y         Y
      481         455         UNIQUE       Ind5189       Ind5189            1           18.6            0.9       0.1 1.266679e-20    NA    X    X            X            X        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        Y        X        Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y
      482         456         UNIQUE       Ind5190       Ind5190            1           18.6            0.9       0.1 6.140533e-21    NA    X    Y            X            X        X        Y        X        Y        Y        Y        X        X        Y        Y        X        Y        X        X        Y        Y        X        Y        X        Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y
      483         457         UNIQUE       Ind5191       Ind5191            1           18.6            0.9       0.1 2.828299e-20    NA    X    X            X            X        Y        Y        X        Y        Y        Y        X        Y        Y        Y        X        Y        X        X        X        Y        X        X        X        Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y
      484         458         UNIQUE       Ind5192       Ind5192            1           18.6            0.9       0.1 1.369655e-20    NA    X    X            X            X        X        X        Y        Y        X        X        X        X        X        Y        X        X        X        Y        X        Y        Y        Y        X        Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         Y         Y
      485         459         UNIQUE       Ind5193       Ind5193            1           18.6            0.9       0.1 4.086651e-21    NA    X    X            X            X        X        Y        Y        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        Y        Y        Y        X        Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y
      486         460         UNIQUE       Ind5194       Ind5194            1           18.6            0.9       0.1 1.908831e-20    NA    X    Y            X            X        X        Y        Y        Y        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y
      487         461         UNIQUE       Ind5195       Ind5195            1           18.6            0.9       0.1 4.765044e-20    NA    X    X            X            X        Y        Y        X        X        X        Y        X        Y        X        Y        Y        Y        Y        Y        X        X        X        X        Y        Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y
      488         462         UNIQUE       Ind5196       Ind5196            1           18.6            0.9       0.1 2.997637e-21    NA    X    Y            X            X        X        Y        X        X        X        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         Y         Y         Y         Y
      489         463         UNIQUE       Ind5197       Ind5197            1           18.6            0.9       0.1 6.683041e-21    NA    X    X            X            X        X        Y        X        Y        X        X        X        X        Y        Y        Y        Y        X        Y        X        X        Y        Y        X        Y         X         Y         Y         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y
      490         464         UNIQUE       Ind5198       Ind5198            1           18.6            0.9       0.1 3.178610e-20    NA    X    Y            X            X        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        X        Y        Y        X        X         Y         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y       -99       -99         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y
      491         465         UNIQUE       Ind5199       Ind5199            1           18.6            0.9       0.1 3.619471e-21    NA    X    X            X            X        X        Y        X        Y        X        Y        Y        Y        X        Y        X        X        X        Y        X        X        X        X        Y        Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X
      492         466         UNIQUE       Ind5200       Ind5200            1           18.6            0.9       0.1 2.088687e-20    NA    X    X            X            X        X        Y        X        Y        X        X        X        Y        Y        Y        X        Y        X        X        Y        Y        X        Y        Y        Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         X         Y
      493         467         UNIQUE       Ind5201       Ind5201            1           18.6            0.9       0.1 7.013558e-21    NA    X    X            X            X        X        X        X        Y        X        X        X        Y        X        Y        X        X        X        Y        X        X        X        Y        X        Y         Y         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y
      494         468         UNIQUE       Ind5202       Ind5202            1           18.6            0.9       0.1 5.025657e-21    NA    X    Y            X            X        X        X        X        X        X        Y        X        X        X        Y        X        Y        X        Y        X        Y        X        X        X        Y         Y         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         Y         Y         X         X         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         Y         X         Y         Y         Y         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y
      495         469         UNIQUE       Ind5203       Ind5203            1           18.6            0.9       0.1 1.504981e-21    NA    X    Y            X            X        X        X        Y        Y        Y        Y        Y        Y        Y        Y        X        Y        X        Y        X        Y        X        Y        X        X         X         X         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         X         X         X         X         X         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         X         Y
      496         470         UNIQUE       Ind5204       Ind5204            1           18.6            0.9       0.1 3.407461e-20    NA    X    X            X            X        X        Y        X        Y        X        Y        X        Y        X        Y        X        Y        X        X        X        Y        X        X        X        Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y
      497         471         UNIQUE       Ind5205       Ind5205            1           18.6            0.9       0.1 3.486750e-21    NA    X    Y            X            X        X        X        X        Y        X        Y        X        Y        X        Y        X        Y        Y        Y        X        Y        X        Y        X        Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y
      498         472         UNIQUE       Ind5206       Ind5206            1           18.6            0.9       0.1 7.887607e-21    NA    X    Y            X            X        X        Y        X        Y        X        X        X        X        X        Y        Y        Y        Y        Y        X        Y        X        X        X        Y         X         Y         X         Y         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         X         X         Y         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         X         X         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X
      499         473         UNIQUE       Ind5207       Ind5207            1           18.6            0.9       0.1 1.348662e-20    NA    X    X            X            X        X        X        X        X        X        Y        X        Y        Y        Y        Y        Y        X        X        X        Y        X        Y        X        Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y
      500         474         UNIQUE       Ind5208       Ind5208            1           18.6            0.9       0.1 4.990007e-20    NA    X    Y            X            X        X        X        Y        Y        Y        Y        X        Y        X        Y        X        X        X        X        Y        Y        X        X        X        Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         Y         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         X         X         Y         Y         Y         X         X
      501         475         UNIQUE       Ind5209       Ind5209            1           18.6            0.9       0.1 4.489957e-21    NA    X    Y            X            X        X        X        Y        Y        X        Y        X        X        Y        Y        X        Y        Y        Y        X        X        X        X        Y        Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         X         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         X         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         Y         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         X         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         X         X         X         Y         X         Y         Y         Y         X         X         X         Y
      502         476         UNIQUE       Ind5210       Ind5210            1           18.6            0.9       0.1 4.894931e-21    NA    X    X            X            X        Y        Y        X        X        X        Y        X        X        X        Y        X        X        X        Y        X        X        X        X        X        Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         X         X         Y         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y         Y         Y         X         X         X         X         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y       -99       -99         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         X         X         X         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         Y         X         X         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y
      503         477         UNIQUE       Ind5211       Ind5211            1           18.6            0.9       0.1 6.294815e-21    NA    X    Y            X            X        X        Y        X        Y        X        X        X        Y        Y        Y        Y        Y        Y        Y        Y        Y        X        X        X        X         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         X         Y         X         Y         X         X         X         Y         X         X         X         Y         X         X         Y         Y         X         X         Y         Y         Y         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         X         X         X         X         X         X         Y         X         X         X         Y         X         X         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         X         Y         Y         Y         Y         Y         Y         Y         Y         X         X         X         X         X         Y         X         Y
      504         478         UNIQUE       Ind5212       Ind5212            1           18.6            0.9       0.1 9.016541e-21    NA    X    X            X            X        X        Y        X        X        X        X        X        Y        X        Y        Y        Y        X        Y        Y        Y        Y        Y        Y        Y         Y         Y         X         Y         X         X         X         Y         Y         Y         Y         Y         Y         Y         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         X         X         Y         Y         Y         X         Y         X         X         X         Y         X         Y         X         X         X         Y         Y         Y         X         Y         Y         Y         X         Y         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         X         X         X         X         Y         Y         X         X         Y         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         X         X         Y         X         X         X         Y         Y         Y         X         X         X         Y         Y         Y         X         X         X         X         X         Y         Y         Y         X         Y         Y         Y         Y         Y         X         X         X         Y         X         Y         X         X         X         Y         X         X         X         X         X         X         Y         Y         X         Y         X         Y         Y         Y         Y         Y         Y         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         X         X         Y         Y         Y         X         Y
      505         479         UNIQUE       Ind5213       Ind5213            1           18.6            0.9       0.1 1.817124e-18    NA    X    X            X            X        X        Y        X        Y        X        Y      -99      -99        Y        Y        X        Y        X        Y        X        Y        X        X        X        Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         X         Y         Y         X         Y         X         Y         Y         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         X         Y         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X         X         Y         X         Y         X         Y       -99       -99         X         Y         X         Y       -99       -99       -99       -99         Y         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y       -99       -99         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y
      506         480         UNIQUE       Ind5214       Ind5214            1           18.6            0.9       0.1 1.409701e-20    NA    X    X            X            X        X        X      -99      -99        Y        Y        X        Y        Y        Y        X        Y        X        Y        X        X        X        Y        X        Y         X         X         X         X         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         X         X         Y         X         Y         Y         Y         X         Y       -99       -99         X         X         X         X         X         Y         X         X         X         Y         X         Y         X         Y         X         Y         X         Y         X         Y       -99       -99         X         X         X         Y         X         X         X         X         X         Y         X         Y         X         Y         X         Y         X         X         X         X       -99       -99         X         Y         X         Y         Y         Y         X         Y         X   